#include "general.h"


/* Add an OOB position to the *_oobpos array	*/
void oob_add(int **posarray, int *size, int *used, int pos) {
   
   if(*size == *used) {
      if((*posarray = realloc(*posarray, *size + 1)) == NULL)
	 err_sys("add_oob: Memory allocation error");
     
      *size += 1;
   }

   if(debug)
      err_msg("oob_add: Added OOB byte at position %d to %p[%d]", pos, *posarray, *used);

   posarray[0][*used] = pos;
   *used += 1;
}

/* Shift the queue of OOB positions	*/
void oob_shift(int *posarray, int *used) {

    *used -= 1;

    if(debug)
       err_msg("oob_shift: Shifting OOB queue: New usedcount: %d", *used);

    memmove(posarray, posarray + 1, *used * sizeof(int));
}

/* Apply a position correction to a vector of OOB positions	*/
void oob_corvec(int *posarray, int used, int correction) {
    int i;
 
    for(i = 0; i < used; i++)
       posarray[i] += correction;
}
