#include "aesoptunnel.h"

void parse_file(char *filename, char *label) {

   FILE *fptr;
   char linebuffer[120];
   char *ptr, *ptr2, *ptr3;
   int state = 0, port = 0;
   int found = 0;

   if((fptr = fopen(filename, "r")) == NULL)
      fprintf(stderr, "Couldn't open %s for reading\n", filename), exit(-1);

   while(fgets(linebuffer, 120, fptr) != NULL) {
      ptr = linebuffer;

      while(isblank((int)*ptr)) ptr++; /* Skip leading whitespace */

      if(*ptr == '\n')	/* Skip empty lines */
         continue;      

      if(*ptr == '#')	/* Skip comments */
         continue;

      if(strchr(ptr, '$') != NULL) {

         if(state == 1)	/* We read the route */
	    break;

	 if(label == NULL)	/* No label specified, taking first */
	    state = 1;
         else if(!strncmp(label, ptr, strlen(label)))	/* Found label */
	    state = 1;
	 continue;
      }

      if(!state)	/* Line is not for us */
	 continue;

      ptr2 = ptr;
      while(isgraph((int)*ptr2)) ptr2++;

      if(*ptr2 == '\n') {  /* No port given */
         *ptr2 = '\0';
	 found++;
	 add_proxy(ptr, DEFAULT_PORT, probe_all);
         continue;
      }

      *ptr2++ = '\0';	/* Null terminate IP or hostname */

      while(isblank((int)*ptr2)) ptr2++;

      if(*ptr2 != '\n') {	/* Port number given */
         ptr3 = ptr2;

         while(isdigit((int)*ptr3)) ptr3++;
         *ptr3 = '\0';
	 port = atoi(ptr2);
      } else
         port = DEFAULT_PORT;

      found++;
      add_proxy(ptr, port, probe_all);
   }

   if(!found)
      err_quit("No proxies to use!");

   fclose(fptr);
}
