#include "aesopd.h"

int main(int argc, char **argv) {
   int listenfd[2], num, i;
   unsigned int timeoffset;
   struct sockaddr *cli;
   socklen_t clilen, clilensave;   
   fd_set rdsettmp, wrsettmp;
   struct timeval tv;
   time_t currtime;
   
   initialise(argc, argv, listenfd);
   lfd = listenfd[0];

   FD_ZERO(&rdset);
   FD_ZERO(&wrset);
   FD_SET(listenfd[0], &rdset);
   if(listenfd[1])
      FD_SET(listenfd[1], &rdset);

   maxfd = MAX(listenfd[0], listenfd[1]);

#ifdef IPV6
   clilensave = sizeof(struct sockaddr_in6);
#else
   clilensave = sizeof(struct sockaddr_in);
#endif

   cli = Malloc(clilensave);

   for( ; ; ) {
      /* Timeout handling */

      currtime = time(NULL);
      timeoffset = 10000000;	/* Very big timeperiod =) */

      for(i = 0; i < conn_size; i++) {
	 if(IS_ST_TIMEOUT(conn[i])) {
	    if(currtime > conn[i].time) {
	       char *ret;
#ifdef DEBUG
	       err_msg("Timeout for localfd=%d", conn[i].localfd);
#endif
	       aesoplog("Connection from %s timed out.", ret = print_sock(conn[i].localfd));
	       free(ret);
	       Connection_del(&conn[i]);
	       continue;
	    } else
		timeoffset = MIN(timeoffset, (conn[i].time - currtime));
	 }
      }

      tv.tv_sec = timeoffset+1;		/* +1 to prevent race conditions */
      tv.tv_usec = 0;

      /* End of timeout handling */

      rdsettmp = rdset;
      wrsettmp = wrset;
#ifdef DEBUG
      err_msg("main: in select()");
#endif
      num = select(maxfd+1, &rdsettmp, &wrsettmp, NULL, &tv);

      if(num == -1)
	 if(errno == EINTR)
	    continue;
	 else
	    err_sys("main: Select error");
      else if(num == 0)
	 continue;		/* Timeout detected */
#ifdef DEBUG
      err_msg("main: selectloop: select returned %d", num);
#endif

      /* See if we can accept a new connection	*/
      if(FD_ISSET(listenfd[0], &rdsettmp)) {
	 int connfd, i;
	 char *ret;

	 clilen = clilensave;

	 if((connfd = accept(listenfd[0], cli, &clilen)) == -1) {
	    if(errno == EWOULDBLOCK || errno == ECONNABORTED)
	       continue;	/* Connection was reset before we could accept */
	    else
	       continue;
	 }	
#ifdef DEBUG
	 err_msg("main: accepted connection from %s on fd=%d", ret = w_sock_ntop(cli), connfd);
	 free(ret);
#endif
	 aesoplog("Accepted connection from %s.", ret = w_sock_ntop(cli));
	 free(ret);

	 i = Connection_add(connfd);
	 Connection_DH_init(&conn[i], AS_NORMAL);
      }

      /* See if we got a UDP probe	*/
      if(FD_ISSET(listenfd[1], &rdsettmp)) {
	 char mesg[256], *ret;
	 int n;

	 clilen = clilensave;
      
	 n = recvfrom(listenfd[1], mesg, 256, 0, cli, &clilen);
#ifdef DEBUG
	 err_msg("main: Received UDP probe from %s consisting of %d bytes", ret = w_sock_ntop(cli), n);
	 free(ret);
#endif
	 aesoplog("Received UDP probe from %s consisting of %d bytes.", ret = w_sock_ntop(cli), n);
	 free(ret);
	 if(!strncmp(mesg, "AESO", 4))
	    sendto(listenfd[1], "AESO UP", 7, 0, cli, clilen);
      }

      for(i = 0; i < conn_size; i++) {
	 if(conn[i].status == ST_NOTUSED)
	    continue;

	 if(FD_ISSET(conn[i].localfd, &rdsettmp)) {
	    if(conn[i].status == ST_DHRECV1 || conn[i].status == ST_DHRECV3)
	       Connection_DH_readdata(&conn[i], FROM_LOCAL);
	    else if(conn[i].status == ST_WAITINF) {
	       Connection_process(&conn[i]);
	       continue;
	    } else if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_LOCAL, 0);
	 }

	 if(FD_ISSET(conn[i].localfd, &wrsettmp)) {
	    if(conn[i].status == ST_DHSEND1 || conn[i].status == ST_DHSEND3)
	       Connection_DH_senddata(&conn[i], TO_LOCAL);
	    else if(IS_ST_PROCESS(conn[i]))
	       Writedata(&conn[i], TO_LOCAL);
	 }

	 if(FD_ISSET(conn[i].remotefd, &rdsettmp)) {
	    if(conn[i].status == ST_DHRECV2)
	       Connection_DH_readdata(&conn[i], FROM_REMOTE);
	    else if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_REMOTE, 0);
	 }

	 if(FD_ISSET(conn[i].remotefd, &wrsettmp)) {
	    if(conn[i].status == ST_DHSEND2)
	       Connection_DH_senddata(&conn[i], TO_REMOTE);
	    else if(IS_ST_PROCESS(conn[i]))
	       Writedata(&conn[i], TO_REMOTE);
	    else if(conn[i].status == ST_INPROGR)
	       CheckConnection(&conn[i]);
	 }
      }
   }
}
