#include "aesoptunnel.h"

int probe_proxy(char *ip, int port, int inet6) {
   int num_probes = 3, sd, result = 1;
   struct sockaddr *sa;
   socklen_t sinlen;

   if(!ipv6support && inet6) {
      err_msg("probe_proxy: Warning, host not built with IPv6 support, skipping host.");
      return 0;
   }      

   sa = w_setsockaddr(ip, port, &sinlen, inet6);

   if((sd = socket(sa->sa_family, SOCK_DGRAM, 0)) == -1) {
      if(errno == EAFNOSUPPORT) {
	 err_msg("probe_proxy: Warning, host built with IPv6 support, but without IPv6 stack, skipping host.");
	 free(sa);
	 return -1;
      } else
	 err_sys("probe_proxy: Can not create SOCK_DGRAM socket.");
   }

   if(connect(sd, sa, sinlen) == -1)
      err_sys("probe_proxy: Can not connect to dgram socket.");

   while(num_probes--) {
      char rep[12];
      fd_set readset;
      struct timeval tv = {3, 0};
      int n;

      write(sd, "AESO", 4);

      FD_ZERO(&readset);
      FD_SET(sd, &readset);
      n = select(sd+1, &readset, NULL, NULL, &tv);

      if(n) {
	 if(read(sd, rep, 9) == -1)
	    break;
	 if(strncmp(rep, "AESO UP", 7)) {
	    err_msg("probe_proxy: Incorrect response on probe, skipping host.");
	    break;
	 } else {	/* Got correct reply */
	    result = 0;
	    break;
	 }
      } else		/* Timeout	*/
	 continue;
   }

   close(sd);
   free(sa);
   return result;
}
