#include "general.h"

int linecount = 0;
Keyword *keys = NULL;
int num_keys = 0;

/* Parse a 'key = value' configuration file	*/
void conf_parse(char *file) {

   FILE *fptr;
   char *ptr, *ptr2, *ptr3;
   linecount = 0;

   if((fptr = fopen(file, "r")) == NULL)
      err_quit("Couldn't open %s for reading.", file);

   while((ptr = ptr2 = getnextline(fptr)) != NULL) {
      while(isalnum((int)*ptr2)) ptr2++;

      *ptr2++ = 0;      
      ptr2 = skip_whitespace(ptr2);

      if(*ptr2 != '=')
	 err_quit("conf_parse: Syntax error at line %d. Not in 'key = value' format", linecount);

      ptr2 = skip_whitespace(ptr2+1);
      
      if(*ptr2 == '\n')
	 err_quit("conf_parse: Syntax error at line %d, Not in 'key = value' format", linecount);

      ptr3 = ptr2;
      while(isgraph((int)*ptr3)) ptr3++;
      *ptr3 = 0;
      add_keyvaluepair(ptr, ptr2);
   }
  
   fclose(fptr);
}

/* Add a key/value pair to the Keywords array after key validation	*/
void add_keyvaluepair(char *key, char *value) {
   if(check_key(key) == -1)
      err_quit("add_keyvaluepair: Invalid keyword '%s' at line %d.", key, linecount);

   keys = Realloc(keys, (num_keys+1) * sizeof(Keyword));

   keys[num_keys].key = strdup(key);
   keys[num_keys].value = strdup(value);
   num_keys++;
}

/* Check if key is a valid keyword	*/
int check_key(char *key) {
   int i;

   for(i = 0; keywords[i] != NULL; i++)
      if(!strcmp(keywords[i], key))
	 return 0;

   return -1;
}

/* Free all data allocated by conf_parse()	*/
void conf_cleanup(void) {
   int i;
   for(i = 0; i < num_keys; i++) {
      free(keys[i].key);
      free(keys[i].value);
   }
   free(keys);
}

/* Get value linked to key, or NULL if key doesnt exist*/
char *getvalue(char *key) {
   int i;
   for(i = 0; i < num_keys; i++)
      if(!strcmp(keys[i].key, key))
	 return keys[i].value;
   return NULL;
}

char *skip_whitespace(char *ptr) {
   while((*ptr == ' ') || (*ptr == '\t')) ptr++;

   return ptr;
}

/* Get the next non-empty, non-comment line, at the first non-white space char	*/
char *getnextline(FILE *fptr) {
   static char lbuf[120], *lbufptr;

   while(fgets(lbuf, 120, fptr) != NULL) {
      linecount++;
      lbufptr = skip_whitespace(lbuf);

      if(*lbufptr == '#')
	 continue;

      if(*lbufptr == '\n')
	 continue;

      return skip_whitespace(lbuf);
   }
   return NULL;
}
