#ifndef CRYPTO_H
#define CRYPTO_H

#define RANDOM_SEED_FILE	"/dev/urandom"

unsigned int urand(void);
int InitRandomStruct(R_RANDOM_STRUCT *randomStruct);
int InitProtoKey(int bits, int fermat, R_RSA_PROTO_KEY *protoKey);
int StorePublicKey(char *file, R_RSA_PUBLIC_KEY *publicKey);
int LoadPublicKey(char *file, R_RSA_PUBLIC_KEY *publicKey);
int StorePrivateKey(char *file, R_RSA_PRIVATE_KEY *privateKey);
int LoadPrivateKey(char *file, R_RSA_PRIVATE_KEY *privateKey);
int StorePart(FILE *fptr, void *src, int size);
int LoadPart(FILE *fptr, void *dest, int size);
char *MD5Hash(unsigned char *passphrase);

#endif
