/*
   CIPE - encrypted IP over UDP tunneling

   ioctl.c - ioctl interface, user side

   Copyright 1996 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: ioctl.c,v 1.1 1996/10/05 23:59:24 olaf Exp $ */

#include "cipe.h"
#include "ioctl.h"
#include <net/if.h>
#include <sys/ioctl.h>

#define IFRSETUP                                                        \
    struct ifreq ifr;                                                   \
    strcpy(ifr.ifr_name, ifname);                                       \
    ifr.ifr_data=(void*)sio;

int ioctl_getpar(int fd, char *ifname, struct siocgifcippar *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCGIFCIPPAR, &ifr);
}

int ioctl_setpar(int fd, char *ifname, struct siocsifcippar *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCSIFCIPPAR, &ifr);
}

int ioctl_setkey(int fd, char *ifname, struct siocsifcipkey *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCSIFCIPKEY, &ifr);
}

int ioctl_attach(int fd, char *ifname, struct siocsifcipatt *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCSIFCIPATT, &ifr);
}

