/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: xwritev.c,v 1.2 2000/12/13 01:38:56 olaf Exp $ */

#include <sys/uio.h>
#include "cipelib.h"

int xwritev(int fd, struct iovec *vec, size_t cnt)
{
    int e=0, t=0;
    while (1) {
        if ((e=writev(fd, vec, cnt))<0)
            return e;
        t+=e;
        while (e>=vec->iov_len) {
            if (--cnt<=0)
                return t;
            e-=vec->iov_len;
            ++vec;
        }
        vec->iov_base+=e;
        vec->iov_len-=e;
    }
}
