/*
   CIPE - encrypted IP over UDP tunneling

   ciped.h - prototypes for user level routines

   Copyright 1997 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: ciped.h,v 1.6 2000/12/16 17:49:06 olaf Exp $ */

#include <signal.h>
#include <netinet/in.h>
#include "cipe.h"
#include "options.h"

/* options.c */
struct options {
    const char * const oname;
    const char otyp;
    union {
	int ovint;
	char *ovstr;
	struct sockaddr_in *ovsaddr;
    } ov;
};
extern struct options opts[];
#define Tbool	0
#define Tint	1
#define Tstr	2
#define Taddr	3
#define Tuaddr	4
#define Ttaddr	5
#define Tsecret 6

#define OI(x)      (opts[O##x].ov.ovint)
#define OS(x)      (opts[O##x].ov.ovstr)
#define OA(x)      (opts[O##x].ov.ovsaddr)
#define OAaddr(x)  (OA(x)->sin_addr)
#define OAport(x)  (OA(x)->sin_port)
