#ifndef CipeEngineDefined
#define CipeEngineDefined

#include "stdio.h"
#include "windows.h"
#include "winnt.h"
#include "ctype.h"
#include "memory.h"
#include "winsock2.h"
#include "iphlpapi.h"
#include "constants.h"

#include "CipeGenericIO.h"
#include "CipeSocketIO.h"
#include "CipeTaskIO.h"
#include "CipeTapIO.h"
#include "CipePeer.h"
#include "CipeBase.h"

using namespace std;

//========================================================================================
//
//========================================================================================
typedef enum
   {
    STATE_RUNNING,
    STATE_PENDING,
    STATE_FORCE,
    STATE_STOPPED
   }
CipeShutdownState;

class CipeEngineException
   {
   };

class CipeEngine : public CipeBase, public vector <CipeGenericIO *>
   {
    private:   CipeShutdownState m_State;
               CipePeerList m_PeerList;
               HANDLE *m_EventTable;
               WSADATA m_WsaData;

    public:    CipeEngine() throw (CipeEngineException);
               ~CipeEngine();

    public:    void EventLoop() throw (CipeEngineException);
               void Load() throw (CipeEngineException);
               void Shutdown();
               void Purge();

    protected: BOOL TestForActiveHandles();
               void QueueUpAsyncRequests();
               int Select();

    public:    CipeGenericIO &operator[] (unsigned long p_Subscript) throw (CipeSubscriptException);
   };

//========================================================================================
//                                   End of Source
//========================================================================================
#endif
