#include "CipeServiceMgr.h"
#include "hexdump.h"

//========================================================================================
//
//========================================================================================
CipeEngine *CipeServiceMgr::m_Engine = 0;

//========================================================================================
//
//========================================================================================
int CipeServiceMgr::ServiceDispatchInit()
   {
    int l_Return = 0;

    SERVICE_TABLE_ENTRY l_DispatchTable[] =
       {
        {TEXT ("CIPE_Daemon"), (LPSERVICE_MAIN_FUNCTION) CipeServiceMgr::ServiceInit},
        {NULL, NULL}
       };

    if (StartServiceCtrlDispatcher (l_DispatchTable))
       l_Return = TRUE;
    else
       DbgPrint ("[SERVICE_MANAGER] StartServiceCtrlDispatcher error\n");

    return l_Return;
   }

void CipeServiceMgr::ServiceInit (unsigned long argc, LPTSTR *argv) throw (CipeServiceMgrException)
   {
    if (! StartCipeDriver()) // Start driver first
       {
        DbgPrint ("[SERVICE_MANAGER] Cipe adapter driver cannot be started\n");
        throw CipeServiceMgrException();
       }

    if (m_ServiceStatusHandle)
       {
        DbgPrint ("[SERVICE_MANAGER] Service has already been initialized. Cannot start more than one\n");
        throw CipeServiceMgrException();
       }

    m_ServiceStatusHandle = RegisterServiceCtrlHandler
       (
        TEXT ("CIPE_Daemon"),
        (LPHANDLER_FUNCTION) CipeServiceMgr::ServiceEvent
       );

    if (! m_ServiceStatusHandle)
       {
        DbgPrint ("[SERVICE_MANAGER] couldn't register service control handler\n");
        throw CipeServiceMgrException();
       }

    m_ServiceStatus.dwServiceType             = SERVICE_WIN32_OWN_PROCESS;
    m_ServiceStatus.dwCurrentState            = SERVICE_START_PENDING;
    m_ServiceStatus.dwControlsAccepted        = SERVICE_ACCEPT_STOP;
    m_ServiceStatus.dwWin32ExitCode           = 0;
    m_ServiceStatus.dwServiceSpecificExitCode = 0;
    m_ServiceStatus.dwCheckPoint              = 0;
    m_ServiceStatus.dwWaitHint                = 0;

    SetServiceStatus (m_ServiceStatusHandle, &m_ServiceStatus); // Tell everyone that we're trying to start

    try
       {
        //================================================================
        // We used to wait on the RpcSs service before starting the driver
        // and we may have to again...
        //================================================================
        DbgPrint ("[SERVICE_MANAGER] Starting CIPE Event handler\n");

        CipeEngine l_CipeEngine;

        m_Engine = &l_CipeEngine;

        m_ServiceStatus.dwCurrentState = SERVICE_RUNNING;

        SetServiceStatus (m_ServiceStatusHandle, &m_ServiceStatus); // Tell everyone that we're running now

        l_CipeEngine.EventLoop();
       }
    catch (CipeEngineException &e_Exception)
       {
        DbgPrint ("[SERVICE_MANAGER] Cipe event handler failed to start\n");
       }

    DbgPrint ("[SERVICE_MANAGER] Cipe service has stopped\n");

    m_ServiceStatus.dwCurrentState  = SERVICE_STOPPED;
    m_ServiceStatus.dwWin32ExitCode = 0;
    m_ServiceStatus.dwCheckPoint    = 0;
    m_ServiceStatus.dwWaitHint      = 0;

    SetServiceStatus (m_ServiceStatusHandle, &m_ServiceStatus); // Tell everyone that we've stopped now
   }

void CipeServiceMgr::ServiceEvent (DWORD p_OpCode)
   {
    switch (p_OpCode)
       {
        case SERVICE_CONTROL_STOP:
           {
            DbgPrint ("[SERVICE_MANAGER] service has been told to stop\n");

            m_ServiceStatus.dwCurrentState  = SERVICE_STOP_PENDING;
            m_ServiceStatus.dwWaitHint      = DAEMON_SELECT_TIMEOUT;
            m_ServiceStatus.dwWin32ExitCode = 0;
            m_ServiceStatus.dwCheckPoint    = 0;

            SetServiceStatus (m_ServiceStatusHandle, &m_ServiceStatus);
            Shutdown();
            break;
           }

        default:
           {
            SetServiceStatus (m_ServiceStatusHandle, &m_ServiceStatus);
            break;
           }
       }
   }

//========================================================================================
//
//========================================================================================
BOOL CipeServiceMgr::ConsoleEvent (unsigned long p_Type)
   {
    Shutdown();
    return TRUE;
   }

void CipeServiceMgr::ConsoleInit()
   {
    if (StartCipeDriver())
       {
        SetConsoleCtrlHandler ((PHANDLER_ROUTINE) CipeServiceMgr::ConsoleEvent, TRUE);

        CipeEngine l_CipeEngine;

        m_Engine = &l_CipeEngine;

        l_CipeEngine.EventLoop();
       }
    else
       {
        DbgPrint ("[SERVICE_MANAGER] Cipe adapter driver cannot be started\n");
       }
   }

//========================================================================================
//
//========================================================================================
void CipeServiceMgr::Shutdown()
   {
    DbgPrint ("[SERVICE_MANAGER] Shutting down...\n");

    if (m_Engine)
       {
        m_Engine->Shutdown();
        m_Engine = 0;
       }
   }

//========================================================================================
//                                   End of Source
//========================================================================================
