#ifndef CipeTapIODefined
#define CipeTapIODefined

#include "constants.h"
#include "windows.h"

#include "CipeGenericIO.h"
#include "CipeAdapter.h"
#include "string"
#include "vector"

using namespace std;

//========================================================================================
//
//========================================================================================
class CipeTapIOException
   {
   };

class CipeTapIO : public virtual CipeGenericIO
   {
    private:   vector <CipeGenericIO *> m_SocketList;
               CipeGenericIO *m_TaskObject;
               CipeAdapter &m_Adapter;
               HANDLE m_Handle;

    public:    CipeTapIO (CipeAdapter &p_Adapter);
               ~CipeTapIO();

    public:    virtual void Send (CipePacketDescriptor &p_Buffer);
               virtual void RequestAsyncReceive();
               virtual void CompleteAsyncReceive();

    public:    virtual unsigned long TxErr();
               virtual unsigned long RxErr();
               virtual unsigned long Tx();
               virtual unsigned long Rx();

    public:    virtual void Enjoin (CipeGenericIO &p_Object);

    public:    virtual unsigned long Address() {return m_Adapter.Address();}
               virtual string &AssociateName() {return m_Adapter.Name();}
               virtual string &Name()          {return m_Adapter.Name();}

    protected: BOOL IsArpRequest (CipePacketDescriptor &p_Buffer);
               void ArpReply (CipeGenericIO &p_Object);
               void UpdateAdapterStatistics();
   };

//========================================================================================
//                                   End of Source
//========================================================================================
#endif
