//=============================================================================================
//
//=============================================================================================
#include "CipeAdapter.h"
#include "constants.h"
#include "hexdump.h"

using namespace std;

//=============================================================================================
//
//=============================================================================================
CipeAdapter::CipeAdapter (HKEY &p_Key, string &p_Name) throw (CipeAdapterException)
   {
    char l_Buffer [256];

    if (m_AdapterNumber = atol (p_Name.c_str()))
       sprintf (l_Buffer, "%ld", m_AdapterNumber);
    else if (p_Name.size() > 0 && p_Name [p_Name.size() - 1] == '0')
       sprintf (l_Buffer, "0");
    else
       sprintf (l_Buffer, "%s", p_Name.c_str());

    m_AdapterID = string ("CIPE") + (char *) l_Buffer;

    Load (p_Key);
   }

CipeAdapter::~CipeAdapter()
   {
   }

void CipeAdapter::Load (HKEY &p_Key) throw (CipeAdapterException)
   {
    HKEY l_Key;

    RegQueryVal (p_Key, (OSType() > 4 ? "NetCfgInstanceId" : "ServiceName"), m_AdapterName);

    if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, RegParameterPath().c_str(), 0, KEY_READ, &l_Key) == ERROR_SUCCESS)
       {
        RegQueryVal (l_Key, "InUseBy", m_InUseBy);
        if (m_InUseBy == "") m_InUseBy = MyProductName();
        RegCloseKey (l_Key);
       }

    if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, RegTcpipPath().c_str(), 0, KEY_READ, &l_Key) == ERROR_SUCCESS)
       {
        string l_Value;
        m_AdapterAddress = inet_addr (RegQueryVal (l_Key, "IPaddress", l_Value).c_str());
        RegCloseKey (l_Key);
       }

    if (! IsUsable())
       {
        throw CipeAdapterException();
       }
   }

void CipeAdapter::Commit()
   {
    HKEY l_Key;

    if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, RegParameterPath().c_str(), 0, KEY_WRITE, &l_Key) == ERROR_SUCCESS)
       {
        RegSetVal (l_Key, "InUseBy", m_InUseBy);
        RegCloseKey (l_Key);
       }
   }

void CipeAdapter::Report()
   {
    DbgPrint
       (
        "Adapter [%s] = [%s][%s][%s][%s]\n",
        DisplayName().c_str(),
        Name().c_str(),
        RegServicePath().c_str(),
        inet_str (Address()).c_str(),
        DisplayName().c_str()
       );
   }

//=============================================================================================
//
//=============================================================================================
CipeAdapterList::CipeAdapterList()
   {
    Load();
   }

CipeAdapterList::~CipeAdapterList()
   {
    Purge();
   }

void CipeAdapterList::Purge()
   {
    for (; size(); pop_back()) delete (back());
   }

void CipeAdapterList::Load()
   {
    HKEY l_Key, l_AdapterKey;

    Purge();

    if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, (OSType() > 4 ? NETCARD_REG_KEY_2000 : NETCARD_REG_KEY), 0, KEY_READ, &l_Key) == ERROR_SUCCESS)
       {
        try
           {
            for (int l_Index = 0;; ++l_Index)
               {
                string l_AdapterID = RegEnumVal (l_Key, l_Index), l_Value;

                if (RegOpenKeyEx (l_Key, l_AdapterID.c_str(), 0, KEY_READ, &l_AdapterKey) == ERROR_SUCCESS)
                   {
                    if (RegQueryVal (l_AdapterKey, "Manufacturer", l_Value) == "DKWHeavyIndustries")
                    if (RegQueryVal (l_AdapterKey, "ProductName", l_Value) == "CIPE")
                       {
                        try
                           {
                            push_back (new CipeAdapter (l_AdapterKey, l_AdapterID));
                           }
                        catch (CipeAdapterException &e_Exception)
                           {
                           }
                       }
                   }

                RegCloseKey (l_AdapterKey);
               }
           }
        catch (CipeSubscriptException &e_Exception)
           {
           }

        RegCloseKey (l_Key);
       }
   }

void CipeAdapterList::Commit()
   {
    for (iterator l_Iterator = begin(); l_Iterator != end(); ++l_Iterator)
       {
        (*l_Iterator)->Commit();
       }
   }

void CipeAdapterList::Report()
   {
    DbgPrint ("\nAdapter Listing\n");
    DbgPrint ("-----------------------\n");
    for (iterator l_Iterator = begin(); l_Iterator != end(); ++l_Iterator) (*l_Iterator)->Report();
    DbgPrint ("-----------------------\n");
   }

//=====================================================================================================
//                                       End of Source
//=====================================================================================================
