#include "CipePeer.h"
#include "hexdump.h"

using namespace std;

//=============================================================================================
//
//=============================================================================================
CipePeer::CipePeer (string &p_Name, CipeAdapter &p_Adapter) throw (CipePeerException) : m_Adapter (p_Adapter), m_Name (p_Name), m_DeleteOnSave (FALSE)
   {
    Clear();
    Load();
   }

CipePeer::CipePeer (CipeAdapter &p_Adapter) : m_Adapter (p_Adapter), m_Name ("(untitled)"), m_DeleteOnSave (FALSE)
   {
    Clear();
   }

CipePeer::~CipePeer()
   {
   }

void CipePeer::Clear()
   {
    m_Enabled = TRUE;
    m_EncryptionType = "BLOWFISH";
    m_OriginalName = "";
    m_PeerPTP = "0.0.0.0";
    m_LocalIP = "0.0.0.0";
    m_PeerIP = "0.0.0.0";
    m_LocalPort = 0;
    m_PeerPort = 0;
    m_PacketTimeout = KEY_EXCHANGE_PACKETS;
    m_StartupScript = "";
    m_ShutdownScript = "";
    m_KeyTimeout = KEY_EXCHANGE_TIMEOUT / 1000;
    m_TextKey = "";
    m_DeleteOnSave = FALSE;
   }

void CipePeer::Load() throw (CipePeerException)
   {
    HKEY l_Key;

    if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, RegistryPath().c_str(), 0, KEY_READ, &l_Key) == ERROR_SUCCESS)
       {
        string l_Value;

        if (! (m_Enabled = (BOOL) atol (RegQueryVal (l_Key, "Enabled", l_Value).c_str())))
           m_EncryptionType = "NONE";
        else if (RegQueryVal (l_Key, "KeyData", m_TextKey) == "00000000000000000000000000000000")
           m_EncryptionType = "NONE";
        else if (RegQueryVal (l_Key, "KeyData", m_TextKey) == "")
           m_EncryptionType = "NONE";
        else if (RegQueryVal (l_Key, "EncryptionType", m_EncryptionType) == "")
           m_EncryptionType = "BLOWFISH";

        RegQueryVal (l_Key, "PeerPTP", m_PeerPTP);
        RegQueryVal (l_Key, "LocalIP", m_LocalIP);
        RegQueryVal (l_Key, "PeerIP", m_PeerIP);

        m_LocalPort  = htons (atol (RegQueryVal (l_Key, "LocalPort", l_Value).c_str()));
        m_PeerPort   = htons (atol (RegQueryVal (l_Key, "PeerPort", l_Value).c_str()));

        RegQueryVal (l_Key, "StartupScript", m_StartupScript);
        RegQueryVal (l_Key, "ShutdownScript", m_ShutdownScript);

        if (RegQueryVal (l_Key, "KeyTimeout", l_Value) == "")
           m_KeyTimeout = KEY_EXCHANGE_TIMEOUT / 1000;
        else
           m_KeyTimeout = atol (l_Value.c_str());

        if (RegQueryVal (l_Key, "PacketTimeout", l_Value) == "")
           m_PacketTimeout = KEY_EXCHANGE_PACKETS;
        else
           m_PacketTimeout = atol (l_Value.c_str());

        m_OriginalName = m_Name;

        RegCloseKey (l_Key);
       }
    else
       {
        DbgPrint ("[%s] couldn't load peer registry data\n", Name().c_str());
        throw CipePeerException();
       }
   }

void CipePeer::Commit() throw (CipePeerException)
   {
    string l_DeletionCandidate
       (
        m_DeleteOnSave ? Name().c_str() :
           (
            m_OriginalName != m_Name && m_OriginalName != "" ? m_OriginalName.c_str() : ""
           )
       );

    unsigned long l_Disposition;
    HKEY l_Key;

    //======================================================
    // Make sure that the registry path exists
    //======================================================

    if (RegCreateKeyEx (HKEY_LOCAL_MACHINE, m_Adapter.RegParameterPath().c_str(), 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &l_Key, &l_Disposition) == ERROR_SUCCESS)
       RegCloseKey (l_Key);
    else
       throw CipePeerException();

    if (RegCreateKeyEx (HKEY_LOCAL_MACHINE, m_Adapter.RegPeerPath().c_str(), 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &l_Key, &l_Disposition) == ERROR_SUCCESS)
       RegCloseKey (l_Key);
    else
       throw CipePeerException();

    //======================================================
    // if m_OriginalName != m_Name, then delete the old key
    // before saving the new key. Otherwise, if m_DeleteOnSave
    // is set, then delete the key outright
    //======================================================
    if (l_DeletionCandidate.size() && RegCreateKeyEx (HKEY_LOCAL_MACHINE, m_Adapter.RegPeerPath().c_str(), 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &l_Key, &l_Disposition) == ERROR_SUCCESS)
       {
        DbgPrint ("[%s] is being deleted from the registry\n", l_DeletionCandidate.c_str());
        RegDeleteKey (l_Key, l_DeletionCandidate.c_str());
        RegCloseKey (l_Key);
       }

    if (m_DeleteOnSave)
       ;
    else if (RegCreateKeyEx (HKEY_LOCAL_MACHINE, RegistryPath().c_str(), 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &l_Key, &l_Disposition) == ERROR_SUCCESS)
       {
        char l_Buffer [256];

        DbgPrint ("[%s] is being saved to the registry\n", m_Name.c_str());

        RegSetVal (l_Key, "Enabled", string (m_Enabled ? "1" : "0"));

        RegSetVal (l_Key, "EncryptionType", m_EncryptionType);
        RegSetVal (l_Key, "KeyData", m_TextKey);

        RegSetVal (l_Key, "StartupScript", m_StartupScript);
        RegSetVal (l_Key, "ShutdownScript", m_ShutdownScript);

        RegSetVal (l_Key, "PeerPTP", m_PeerPTP);
        RegSetVal (l_Key, "LocalIP", m_LocalIP);
        RegSetVal (l_Key, "PeerIP", m_PeerIP);

        RegSetVal (l_Key, "LocalPort", num_str (ntohs (m_LocalPort)));
        RegSetVal (l_Key, "PeerPort", num_str (ntohs (m_PeerPort)));

        RegSetVal (l_Key, "PacketTimeout", num_str (m_PacketTimeout));
        RegSetVal (l_Key, "KeyTimeout", num_str (m_KeyTimeout));

        m_OriginalName = m_Name;

        RegCloseKey (l_Key);
       }
    else
       {
        DbgPrint ("[%s] couldn't update it's registry data\n", Name().c_str());
       }
   }

void CipePeer::Report()
   {
    DbgPrint
       (
        "Peer [%s] of Adapter [%s] Key=[%s] Local PTP=[%s] Remote PTP=[%s]\n",
        Name().c_str(),
        m_Adapter.DisplayName().c_str(),
        TextKey().c_str(),
        inet_str (LocalPTP()).c_str(),
        PeerPTP().c_str()
       );
   }

//=============================================================================================
//
//=============================================================================================
CipePeerList::CipePeerList()
   {
    Load();
   }

CipePeerList::~CipePeerList()
   {
    Purge();
   }

void CipePeerList::Purge()
   {
    for (; size(); pop_back()) delete (back());
   }

void CipePeerList::Load()
   {
    unsigned long l_AdapterCount = m_AdapterList.size();

    Purge();

    for (int l_AdapterIndex = 0; l_AdapterIndex < l_AdapterCount; ++l_AdapterIndex)
       {
        HKEY l_Key;

        if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, m_AdapterList [l_AdapterIndex].RegPeerPath().c_str(), 0, KEY_READ, &l_Key) == ERROR_SUCCESS)
           {
            try
               {
                for (unsigned long l_PeerIndex = 0;; ++l_PeerIndex)
                   {
                    try
                       {
                        push_back (new CipePeer (RegEnumVal (l_Key, l_PeerIndex), m_AdapterList [l_AdapterIndex]));
                       }
                    catch (CipePeerException &e_Exception)
                       {
                       }
                   }
               }
            catch (CipeSubscriptException &e_Exception)
               {
               }

            RegCloseKey (l_Key);
           }
       }
   }

void CipePeerList::Commit()
   {
    try
       {
        m_AdapterList.Commit();

        for (iterator l_Iterator = begin(); l_Iterator != end(); ++l_Iterator)
           {
            try
               {
                (*l_Iterator)->Commit();
               }
            catch (CipePeerException &e_Exception)
               {
                DbgPrint ("[%s] info could not be saved to the registry\n", (*l_Iterator)->Name().c_str());
               }
           }
       }
    catch (CipeAdapterException &e_Exception)
       {
       }
   }

void CipePeerList::Report()
   {
    m_AdapterList.Report();
    DbgPrint ("\nPeer Listing\n");
    DbgPrint ("-----------------------\n");
    for (iterator l_Iterator = begin(); l_Iterator != end(); ++l_Iterator) (*l_Iterator)->Report();
    DbgPrint ("-----------------------\n");
   }

//=====================================================================================================
//                                       End of Source
//=====================================================================================================
