#ifndef CipeServiceBaseDefined
#define CipeServiceBaseDefined

#include "windows.h"
#include "winsvc.h"
#include "constants.h"

#include "CipeBase.h"

typedef enum SVC_STATE_QUERY
   {
    SVC_STATE_STARTED,
    SVC_STATE_STOPPED
   };

class CipeServiceBaseException
   {
   };

class CipeServiceBase : public CipeBase
   {
    protected: static SERVICE_STATUS_HANDLE m_ServiceStatusHandle;
               static SERVICE_STATUS m_ServiceStatus;
               static SC_HANDLE m_ManagerHandle;
               static SC_HANDLE m_ServiceHandle;

    public:    static void OpenSvcHandle (string &p_Name) throw (CipeServiceBaseException);
               static void CloseSvcHandle();

    public:    static void OpenMgrHandle() throw (CipeServiceBaseException);
               static void CloseMgrHandle();

    public:    static void GetSvcInfo (SERVICE_STATUS &p_Status);
               static unsigned long GetSvcState (string &p_Name);

    public:    static BOOL InstallSvc (string &p_Name, string &p_Executable, string &p_DisplayName);
               static BOOL WaitSvc (string &p_Name, SVC_STATE_QUERY p_State = SVC_STATE_STARTED);
               static BOOL StartSvc (string &p_Name);
               static BOOL StopSvc (string &p_Name);
               static BOOL RemoveSvc (string &p_Name);
               static BOOL SvcExists (string &p_Name);

    public:    static BOOL StartCipeService()      {WaitSvc ("RpcSs"); return StartSvc (CIPE_SERVICE_NAME);}
               static BOOL StopCipeService()       {return StopSvc (CIPE_SERVICE_NAME);}
               static BOOL StartCipeDriver()       {return StartSvc (CIPE_DRIVER_NAME);}
               static BOOL StopCipeDriver()        {return StopSvc (CIPE_DRIVER_NAME);}
               static BOOL CipeServiceExists()     {return SvcExists (CIPE_SERVICE_NAME);}
               static unsigned long GetCipeState() {return GetSvcState (CIPE_SERVICE_NAME);}

    public:    static BOOL InstallCipeService();
               static BOOL RemoveCipeService();

    public:    static void OpenSvcHandle (const char *p_Name)
                  {
                   OpenSvcHandle (string (p_Name ? p_Name : ""));
                  }

               static BOOL StartSvc (const char *p_Name)
                  {
                   return StartSvc (string (p_Name ? p_Name : ""));
                  }

               static BOOL StopSvc (const char *p_Name)
                  {
                   return StopSvc (string (p_Name ? p_Name : ""));
                  }

               static BOOL WaitSvc (const char *p_Name)
                  {
                   return WaitSvc (string (p_Name ? p_Name : ""));
                  }

               static BOOL RemoveSvc (const char *p_Name)
                  {
                   return RemoveSvc (string (p_Name ? p_Name : ""));
                  }

               static BOOL SvcExists (const char *p_Name)
                  {
                   return SvcExists (string (p_Name ? p_Name : ""));
                  }

               static unsigned long GetSvcState (const char *p_Name)
                  {
                   return GetSvcState (string (p_Name ? p_Name : ""));
                  }
   };

//========================================================================================
//                                   End of Source
//========================================================================================
#endif
