#ifndef CipeTaskIODefined
#define CipeTaskIODefined

#include "constants.h"
#include "windows.h"
#include "winsock2.h"

#include "CipeGenericIO.h"
#include "string"
#include "queue"
#include "list"

using namespace std;

//========================================================================================
//
//========================================================================================
class CipeTaskIOException
   {
   };

class CipeTaskIO : public virtual CipeGenericIO, public queue <char *>
   {
    private:   PROCESS_INFORMATION m_ProcessInfo;
               STARTUPINFO m_StartupInfo;
               char *m_LastCommand;
               string m_Name;

    public:    CipeTaskIO() throw (CipeTaskIOException);

    public:    virtual unsigned long Address() {return 0;}
               virtual string &Name()          {return m_Name;}

    public:    virtual void Send (CipePacketDescriptor &p_Buffer);

    public:    virtual void RequestAsyncReceive();
               virtual void CompleteAsyncReceive();

    public:    virtual void Enjoin (CipeGenericIO &p_Object);
   };

//========================================================================================
//                                   End of Source
//========================================================================================
#endif
