/* logging.c - Logging
 *  Copyright (C) 2001, 2002 Timo Schulz 
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version. 
 *  
 * OpenCDK is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details. 
 *  
 * You should have received a copy of the GNU General Public License 
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */ 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdarg.h>

#include "opencdk.h"

const char *version = "Lib"PACKAGE" "VERSION;

typedef int (*_cdk_printf)( const char *fmt, va_list arg_ptr );
static _cdk_printf my_printf = NULL;
static int logging_mask = 0; /* default is NO logging */

void
cdk_set_logging( int mask )
{
    if ( mask == OPENCDK_LOG_DEBUG )
        mask = 1|2; /* make sure verbose is also enabled */
    logging_mask = mask;
} /* cdk_set_logging */

int
_cdk_get_logging( void )
{
    return logging_mask;
} /* _cdk_get_logging */

void
cdk_set_printf_func( int (*output_func)(const char *fmt, va_list arg_ptr) )
{
    if ( !output_func ) {
        my_printf = NULL;
        return;
    }
    my_printf = output_func;
} /* cdk_set_printf_func */

void
cdk_printf( const char *fmt, ... )
{    
    va_list arg_ptr;

    if ( !logging_mask )
        return;
    va_start( arg_ptr, fmt );
    if ( !my_printf ) {
        printf( PACKAGE": " );
        vprintf( fmt, arg_ptr );
        va_end( arg_ptr );
        return;
    }
    my_printf( fmt, arg_ptr );
    va_end( arg_ptr );
} /* cdk_printf */






