/* main.h
 *       Copyright (C) 2002 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CDK_MAIN_H
#define CDK_MAIN_H

#include "types.h"
#include "context.h"

#define MAX_MPI_BITS 8192
#define MAX_MPI_BYTES (MAX_MPI_BITS/8)

#define IS_UID_SIG(s) (((s)->sig_class & ~3) == 0x10)
#define IS_UID_REV(s) ((s)->sig_class == 0x30)

#define DEBUG_PKT (_cdk_get_log_level () == (CDK_LOG_DEBUG+1))

#define KEY_CAN_ENCRYPT(a) (_cdk_pk_algo_usage((a)) & GCRY_PK_USAGE_ENCR)
#define KEY_CAN_SIGN(a)    (_cdk_pk_algo_usage((a)) & GCRY_PK_USAGE_SIGN)

#define init_packet(ctx) memset ((ctx), 0, sizeof (ctx))

#define wipemem(_ptr,_len) \
do \
{ \
  volatile char *_vptr = (volatile char *)(_ptr); \
  size_t _vlen = (_len); \
  while (_vlen) \
    { \
      *_vptr = 0; \
      _vptr++; \
      _vlen--; \
    } \
} while (0)

/*-- armor.c --*/
const char * _cdk_armor_get_lineend (void);
     
/*-- main.c --*/
int _cdk_get_log_level (void);
void _cdk_log_info (const char * fmt, ...);
void _cdk_log_debug (const char * fmt, ...);
char * _cdk_passphrase_get (const char * prompt);
void _cdk_passphrase_free (char * pw);
int _cdk_is_idea_available (void);

/*-- misc.c --*/
u32 _cdk_timestamp (void);
int _cdk_strcmp (const char * a, const char * b);
u32 _cdk_buftou32 (const byte * buf);
void _cdk_u32tobuf (u32 u, byte * buf);
const char* _cdk_memistr (const char * buf, size_t buflen, const char * sub);

/*-- pubkey.c --*/
int _cdk_pk_algo_usage (int algo);
int _cdk_pk_test_algo (int algo, unsigned int usage);
int _cdk_seckey_get_csum (cdkPKT_secret_key * sk);

/*-- cipher.c --*/
int _cdk_cipher_test_algo (int algo);
int _cdk_md_test_algo (int algo);

/*-- new-packet.c --*/
byte * _cdk_subpkt_get_array (CDK_SUBPKT s, int count, size_t * r_nbytes);
int _cdk_subpkt_add (CDK_SUBPKT root, CDK_SUBPKT node);
int _cdk_subpkt_copy (CDK_SUBPKT * r_dst, CDK_SUBPKT src);
int _cdk_subpkt_hash (CDK_SUBPKT hashed, size_t * r_nbytes, GCRY_MD_HD hd);

/*-- sig-check.c --*/
void _cdk_hash_pubkey (cdkPKT_public_key * pk, GCRY_MD_HD md, int use_fpr);
int _cdk_signature_check (cdkPKT_public_key * pk, cdkPKT_signature *sig,
                          GCRY_MD_HD digest, int * r_expired);
void _cdk_hash_sig_data (cdkPKT_signature * sig, GCRY_MD_HD hd);
void _cdk_hash_userid (cdkPKT_user_id * uid, int sig_version, GCRY_MD_HD md);


/*-- kbnode.c --*/
void _cdk_kbnode_add (CDK_KBNODE root, CDK_KBNODE node);
void _cdk_kbnode_clone (CDK_KBNODE node);

/*-- sesskey.c --*/
int _cdk_pkcs1_sesskey (GCRY_MPI * esk, CDK_DEK dek, int nbits);
int _cdk_pkcs1_digest (byte ** r_md, size_t * r_mdlen, int pk_algo,
                       const byte * md, int digest_algo, unsigned nbits);
int _cdk_seckey_unprotect2 (cdkPKT_secret_key * sk);

/*-- seckey.c --*/
int cdk_hash_passphrase (CDK_DEK dek, char * pw, CDK_S2K_HD s2k, int creat);

/*-- keydb.c --*/
u32 _cdk_keyid_get (CDK_PACKET * pkt, u32 * keyid);
int _cdk_fingerprint_get (CDK_PACKET * pkt, byte * fpr);
     
CDK_KBNODE _cdk_keydb_get_pkblock (CDK_KEYDB_HD hd, u32 * keyid);
CDK_KBNODE _cdk_keydb_get_skblock (CDK_KEYDB_HD hd, u32 * keyid);
CDK_KBNODE _cdk_keydb_find_bykeyid (CDK_KBNODE root, u32 * keyid);

int _cdk_keydb_get_pk_byname (CDK_KEYDB_HD hd, const char * name,
                              cdkPKT_public_key ** ret_pk, int alloced);
int _cdk_keydb_get_sk_byname (CDK_KEYDB_HD hd, const char * name,
                              cdkPKT_secret_key ** ret_sk, int alloced);

/*-- sign.c --*/
int _cdk_sig_create (cdkPKT_public_key * pk, cdkPKT_signature * sig);
int _cdk_sig_hash_for (int pubkey_algo, int pkt_version);
void _cdk_trim_string (char * s, int canon);
int _cdk_sig_complete (cdkPKT_signature * sig, cdkPKT_secret_key * sk,
                       GCRY_MD_HD hd);     

/*-- stream.c --*/
void * _cdk_stream_get_opaque (CDK_STREAM s, int id);
const char * _cdk_stream_get_fname (CDK_STREAM s);
FILE * _cdk_stream_get_fp (CDK_STREAM s);
int _cdk_stream_gets (CDK_STREAM s, char * buf, size_t count);
int _cdk_stream_append (const char * file, CDK_STREAM * ret_s);
int _cdk_stream_get_errno (CDK_STREAM s);
int _cdk_stream_set_blockmode (CDK_STREAM s, size_t nbytes);

/*-- verify.c --*/
void _cdk_result_verify_free (Verify_Result res);
Verify_Result _cdk_result_verify_new (void);

/*-- encrypt.c --*/
int _cdk_proc_signature_packets (CDK_HD hd, GCRY_MD_HD md,
                                 CDK_STREAM inp, CDK_STREAM out);
/*-- read-packet.c --*/
size_t _cdk_pkt_read_len (FILE * inp, int * ret_partial);

#endif /* CDK_MAIN_H */
