#!/bin/sh
# mk-minpg.sh - script to compile the MinPG example application
#
# This file is part of OpenCDK.
#
# OpenCDK is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# OpenCDK is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenCDK; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

CC=gcc
CFLAGS="-O2 -Wall"
CFLAGS="$CFLAGS -I../src"
POPT="/usr/include/popt.h"
LIBS="../src/.libs/libopencdk.a -L/usr/lib -lpopt -L/usr/local/lib -lz -lgcrypt"

echo "check for libpopt"
if [ -e $POPT ]; then
    echo "compiling minpg"
    $CC $CFLAGS -o minpg minpg.c $LIBS
else
    echo "error: you need libpopt to compile minpg"
fi

