
/* A somewhat modified version of Eric Young's cbc_enc.c DES CBC function 
   This code was modifed to be able to use Phil Karn's GNU assembly DES
   function */

/* parts of this are Copyright (C) 1993 Eric Young - see README.EY for more details */

#include "des.h"

void des3_cbc_encrypt(unsigned char *input,long length,key_schedule schedule1,
                      key_schedule schedule2, key_schedule schedule3,
                      unsigned char *ivec,unsigned char encrypt)
{
        register unsigned long t0,t1,xor0,xor1;
	register unsigned long *in,*iv;
	register long l=length;

	in=(unsigned long *)input;
	iv=(unsigned long *)ivec;

	if (encrypt)
		{
                t0 = iv[0];
                t1 = iv[1];
                for (; l>0; l-=8)
                        {
                        in[0]^=t0;
                        in[1]^=t1;
			des(schedule1, (unsigned char *)in);
			des(schedule2, (unsigned char *)in);
			des(schedule3, (unsigned char *)in);
                        t0 = in[0];
                        t1 = in[1];
                        in+=2;
			}
		}
	else
		{
                xor0 = iv[0];
                xor1 = iv[1];
                for (; l>0; l-=8)
                        {
                        t0 = in[0];
                        t1 = in[1];
			des(schedule1, (unsigned char *)in);
			des(schedule2, (unsigned char *)in);
			des(schedule3, (unsigned char *)in);
                        in[0] ^= xor0;
                        in[1] ^= xor1;
                        xor0=t0;
                        xor1=t1;
                        in+=2;
                        }
                }
}
