/* md52.h */

#define MD5BLOCKLEN   64  /* in bytes */
#define MD5HASHLEN    16  /* in bytes */

typedef unsigned long uint32;

struct MD5Context {
	uint32 buf[4];
	uint32 bits[2];
	unsigned char in[64];
};

void MD5Init(struct MD5Context *);
void MD5Update(struct MD5Context *, unsigned char *buf, unsigned len);
void MD5Final(unsigned char digest[16], struct MD5Context *);
void Transform(uint32 buf[4], uint32 in[16]);
