
/* A somewhat modified version of Eric Young's cbc_enc.c DES CBC function 
   This code was modifed to be able to use RC5 encrypt and decrypt functions */

/* parts of this are Copyright (C) 1993 Eric Young */

#include "../../br.h"
#include "rc5.h"

void rc5_cbc_encrypt(unsigned char *input,long length,rc5key key,unsigned char *ivec,unsigned char encrypt)
{
	register unsigned long t0,t1,xor0,xor1;
	register unsigned long *in,*iv;
	register long l=length;

	in=(unsigned long *)input;
	iv=(unsigned long *)ivec;

	BigByteReverse(in,length);
	BigByteReverse(iv,8);

	if (encrypt)
		{
		t0 = iv[0];
		t1 = iv[1];
		for (; l>0; l-=8)
			{
			in[0]^=t0;
			in[1]^=t1;
			RC5encrypt(in,key); 
			t0 = in[0];
			t1 = in[1];
			in+=2;
			}
		}
	else
		{
		xor0 = iv[0];
		xor1 = iv[1];
		for (; l>0; l-=8)
			{
			t0 = in[0];
			t1 = in[1];
			RC5decrypt(in,key);
			in[0] ^= xor0;
			in[1] ^= xor1;
			xor0=t0;
			xor1=t1;
			in+=2;
			}
		}
	BigByteReverse((unsigned long*)input,length);
}
