#include <endian.h>
#include "../aes_std_defs.h"

#define Q_TABLES
#define M_TABLE
#define MK_TABLE
#define ONE_STEP

typedef struct {
u4byte l_key[40];
u4byte s_key[4];
u4byte k_len;
#ifdef ONE_STEP
u4byte  mk_tab[4][256];
#else
u1byte  sb[4][256];
#endif
} twofishkey;

/* 2. Standard interface for AES cryptographic routines             */

/* These are all based on 32 bit unsigned values and may require    */
/* endian conversion for big-endian architectures                   */

    char *cipher_name(void);
    void twofish_set_key(twofishkey *tf_key, const u1byte in_key[], const u4byte key_len);
    void twofish_encrypt(const u1byte in_blk[16], u1byte out_blk[16],twofishkey *tf_key);
    void twofish_decrypt(const u1byte in_blk[16], u1byte out_blk[16],twofishkey *tf_key);

    void twofish_cbc_encrypt(unsigned char *input,long length,twofishkey *tf_key, unsigned char *ivec,unsigned char encrypt);
    void twofish_gen_qtab(void);
    void twofish_gen_mtab(void);
