/* ipsec.h */

/* This header file contains all of the datatypes and definitions
   required by the IPsec core engine */

#ifndef _IPSEC_H
#define _IPSEC_H

#if 0
#define SI_TESTER
#define SI_TESTER_VERBOSE
#endif

#define CERBERUS_VERSION_MAJOR 0
#define CERBERUS_VERSION_MINOR 5
#define NO_ALG 0 /* place holder */

/* Cipher algorithms */
#define RFC_1829 1 /* no longer supported */
#define ESP_DES_CBC 2
#define ESP_3DES_CBC 3
#define ESP_RC5_CBC 4
#define ESP_BLOWFISH_CBC 5
#define ESP_IDEA_CBC 6
#define ESP_NULL 7
#define ESP_MARS_CBC 8
#define ESP_RC6_CBC 9
#define ESP_RIJNDAEL_CBC 10
#define ESP_SERPENT_CBC 11
#define ESP_TWOFISH_CBC 12

/* Authenticator algorithms */
#define RFC_1828 128 /* no longer supported */
#define RFC_1852 129 /* no longer supported */
#define AH_HMACMD5128 130  /* no longer supported */
#define AH_HMACSHA192 131  /* no longer supported */
#define HMACMD596 132
#define HMACSHA96 133

#define CIPHER_TEST_ALG 252
#define AUTH_TEST_ALG 253

#define NULL_ALG 254

#define REPLAY_WINDOW_SIZE 64

#define MAX_RP_SN 0xfffffffe
#define RP_SN_WARN 128
#define SN_LENGTH 4

/* Additional options to be need by the AH code */
#define IPOPT_IPSO_BSO 130
#define IPOPT_IPSO_ESO 133
#define IPOPT_CIPSO    134
#define IPOPT_SATID    136

/* SKB Security Options */
/* Left room for include/linux/ipsec.h compatibility - not sure why*/
#define SKB_SECURITY_IPSEC 0x100 /* Inbound packets, tunnel removed */

/* Allows hole to be punched for IKE */
#define UDP_SOURCE_PORT(udp) ((struct udphdr *)(udp))->source
#define UDP_DEST_PORT(udp) ((struct udphdr *)(udp))->dest

/* This is used to register the IPSEC functions */
struct ipsec_control
{
	void 			(*init)(void);
	void			(*err)(void);
	struct sk_buff*		(*input)(struct sk_buff *s);
	struct sk_buff*		(*output)(struct sk_buff *s, unsigned short next_protocol,unsigned long next_spi);
};

struct ah_header {
       u_char next_header;
       u_char length;
       short reserved;
       u_long spi;
};
#ifdef __KERNEL__
/* kernel max function doesn't work with negative numbers */
#define IPSEC_MAX(a,b) (a>b)?a:b
extern int local_addr(struct device *dev, __u32 src);
extern void generate_ivec(unsigned char * i,int l);
extern struct sk_buff *ipsec_output(struct sk_buff *skb,unsigned short next_protocol, unsigned long next_spi);
extern struct sk_buff *ipsec_input(struct sk_buff *skb);
extern void iph_ah_zerooptions(unsigned char *buff);
extern void iph_ah_prep(unsigned char *buff);
extern void	register_ipsec(struct ipsec_control *ctrl);
extern void	unregister_ipsec(void);
extern struct ipsec_control *ipsec_control;
extern struct sk_buff *ipsec_alloc_skb(struct sk_buff *skb, unsigned short len);
extern void bprintk(unsigned char * b, int len, char * s);
extern char * ntoa(__u32 addr);
extern int check_replay_window(u_long seq, struct sadb_dst_node *d);
extern unsigned int ipsec_mss_delta;

extern long expire_check_time;
extern long expire_check_count;

#ifdef SI_TESTER
extern void si_bprintk(unsigned char * b, int len);
extern unsigned long si_cnt;
#endif

static __inline__ void r_memcpy(unsigned char *b1,unsigned char *b2,int l)
{
	register short i;

	for (i=l-1;i>=0;i--)
		b1[i] = b2[i];
}

static __inline__ unsigned short pad_data(unsigned char *data, unsigned short l,unsigned short o,unsigned short bs) 
{
	int i,j;
	j= (l%bs)?bs-(l%bs):0;
	for (i=o;i<o+j;i++) data[i]=(i-o)+1;
	return(j);
}

#ifdef MODULE
extern void ipsec_inc_mod_count(void);
extern void ipsec_dec_mod_count(void);
#endif

#endif
#endif
