/* transform.h */

#ifndef _TRANSFORM_H
#define _TRANSFORM_H

#define MAX_IPSEC_TRANSFORMS 64

#define AUTH_TRANSFORM  1
#define CIPHER_TRANSFORM 2

/* This is used to register IPSEC transforms */
struct ipsec_transform
{
	void 			(*init_handler)(void);
	void			(*err_handler)(void);
	struct sk_buff*		(*input_handler)(struct sk_buff *s, struct sadb_dst_node *d, struct ipsec_transform *t);
	struct sk_buff*		(*output_handler)(struct sk_buff *s, struct sadb_dst_node *d, struct ipsec_transform *t);
	int			(*sadb_add_handler)(struct sadb_dst_node *d);
	void			(*sadb_delete_handler)(struct sadb_dst_node *d);
	unsigned char		id;
	const char		*name;
 	unsigned char		type;
	struct ipsec_transform	*next;
};

extern void	ipsec_add_transform(struct ipsec_transform *trans);
extern struct ipsec_transform  *ipsec_get_transform(unsigned char id, unsigned char type);
void transform_init(void);

#endif
