#!/bin/bash

rm /tmp/*.OK
counter=1
route add -net 172.30.0.0 gw 172.18.30.33 netmask 255.255.0.0
for conn in `cat /etc/ipsec.conf|grep "conn test"|awk '{print $2}'`; do
	hisaddress=`echo $conn | awk -F "_" '{printf ("172.30.%d.%d\n",$2,$3)}'`
	myaddress=`echo $conn | awk -F "_" '{printf ("172.31.%d.%d\n",$2,$3)}'`
	ifconfig eth0:$counter $myaddress netmask 255.255.255.255
	counter=$((counter+1))
	ipsec auto --up $conn && sleep 1 && ping -c 2 -i 0.1 -I $myaddress $hisaddress && touch /tmp/$conn.OK
done
