<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",5,"Deliverable 1: Vulcan drivers on FreeBSD");

$content =  <<<EOF1

<H2>Testing a large number of connections</H2>
<H3>Seting up SUT3</H3>
<OL>
<LI>Make sure SUT3 is booted with the VULCAN kernel; at the boot prompt:
<PRE>
boot /boot/vulcan
</PRE>
<LI>Login on SUT3 as root
<LI>Get the testscript tar file:
<PRE>
scp &lt;user&gt;@hifn.xelerance.com:/hifn/MASTER/files/conntest.tgz .
</PRE>
<LI>Extract the file:
<PRE>
tar -xzvf conntest.tgz
</PRE>
<LI>Modify the template.conf file and change:
<PRE>
   interfaces="ipsec0=em0"
</PRE>
to 
<PRE>
  interfaces="ipsec0=em1"
</PRE>
<LI>Comment out the debug level if you are testing the speed too:
<PRE>
  plutodebug="all"
</PRE>
to
<PRE>
  plutodebug="none"
</PRE>
<LI>Generate the ipsec.conf file to have 1000 conns:
<PRE>
conngen.pl template.conf 4 > /etc/ipsec.conf
</PRE>
This will overwrite your existing /etc/ipsec.conf, so be careful.
<LI>Add a route for the 172.31 network to be passed to SUT5:
<PRE>
route add -net 172.31.0.0 172.18.30.55 255.255.0.0
</PRE>
<LI>Add a route for the 172.30 netmwork to be passed to SUT7:
<PRE>
route add -net 172.30.0.0 172.18.20.77 255.255.0.0
</PRE>
<LI>Send the setupif.sh script to SUT7:
<PRE>
scp setupif.sh sut7:/root
</PRE>
<LI>Start IPsec:
<PRE>
ipsec setup start
</PRE>
<LI>Start a tcpdump procss to monitor the wire:
<PRE>
tcpdump -n -i em1
</PRE>
</OL>

<H3>Setting up SUT7</H3>
<OL>
<LI>Sut7 can use any kernel for this test.
<LI>Login as root to SUT7
<LI>Pre-set all the IP addreses we will target on the other side of SUT7.  We are going to assign them all to fxp0 which is the management interface, but it doesn't really matter:
<PRE>
setupif.sh 4
</PRE>
<LI>Setup a route to reach back to 172.31 through SUT3--SUT5 tunnel:
<PRE>
route add -net 172.31.0.0 172.18.20.33 255.255.0.0
</PRE>
</OL>

<H3>Setting up SUT5 and running the test</H3>
<OL>
<LI>Make sure SUT5 is booted with the VULCAN kernel; at the boot prompt:
<PRE>
boot /boot/vulcan
</PRE>
<LI>Login as root on SUT5
<LI>Get the testscript tar file:
<PRE>
scp &lt;user&gt;@hifn.xelerance.com:/hifn/MASTER/files/conntest.tgz .
</PRE>
<LI>Extract the file:
<PRE>
tar -xzvf conntest.tgz
</PRE>
<LI>Modify the template.conf file and comment out the debug level if you are testing the speed too:
<PRE>
  plutodebug="all"
</PRE>
to
<PRE>
  plutodebug="none"
</PRE>
<LI>Generate the ipsec.conf file to have 1000 conns:
<PRE>
conngen.pl template.conf 4 > /etc/ipsec.conf
</PRE>
This will overwrite your existing /etc/ipsec.conf, so be careful.
<LI>Add a route for the 172.30 network to be passed to SUT3:
<PRE>
route add -net 172.30.0.0 172.18.30.33 255.255.0.0
</PRE>
<LI>Start IPsec:
<PRE>
ipsec setup start
</PRE>
<LI>Start the test:
<PRE>
connstart.sh
</PRE>
You should see mostly ESP amd isakmp packets on the <I>tcpdump</I> running on SUT3.  The script on SUT5 should not hang, and should terminate normally at the root prompt.

EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>

