<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",3,"Milestone 2: Filling /dev/random from the HiFn Card");

$content =  <<<EOF1

<OL><H2>Testing /dev/random</H2>
<LI>You will need gnuplot for this test, so you can install it on any Linux box you have, or even on this 
FreeBSD server by doing, as root: cd /usr/ports/math/gnuplot  && make install
<LI>Now login as a regular user, and get the random testing script from hifn.xelerance.com:
<pre>
cd \$HOME
scp (user)@hifn.xelerance.com:/hifn/MASTER/files/test1.pl .
</pre>
<LI>perl test1.pl > freebsd.hifn.dat
<LI>Once done, bring the .dat file to the machine where you installed gnuplot, then on that machine do:
<pre>
(echo "set terminal png"
 echo "set output 'freebsd.hifn.png'"
 echo "plot 'freebsd.hifn.dat'" ) | gnuplot -persist -
</pre>
That will generate a file called freebsd.hifn.png. Use a web browser or a image viewer to have a look at it.  You will need to compare with the ones on hifn.xelerance.com, Milestone2.
</OL>

<H2>/dev/random results without HiFn card</H2>
<center>
<img src=freebsd.naked.png>
</center>

<H2>/dev/random results with HiFn card</H2>
<center>
<img src=freebsd.vulcan.png>
</center>

EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>

