#!/usr/bin/perl

$authby = "rsasig";
$template = pop(@ARGV);

open(TEMPLATE, "< $template") || die "Could not open template file $template\n";
while (<TEMPLATE>) {
        print $_
}
close(TEMPLATE);

while(<STDIN>) {
	chop($_);
	($phase2, $mode, $auth, $group, $encrypt) = split(/,/);
	print "conn conn-$phase2-$mode-$auth-$group-$encrypt-$authby\n";
	if ($mode eq "trans") {
		print "\ttype=transport\n";
		print "\tleftprotoport=udp/0\n";
		print "\trightprotoport=udp/1702\n";
	} elsif ($mode eq "tun") {
		print "\ttype=tunnel\n";
	} else {
		die "Mode $mode not understood. Your choice are tun and trans.\n";
	}
	print "\tauthby=$authby\n";
	print "\tphase2=$phase2\n";
	if ($phase2 eq "ah") {
		print "\tphase2alg=$auth;$group\n";
	} elsif ($phase2 eq "esp") {
		print "\tphase2alg=$encrypt-$auth;$group\n";
	} else {
		die "Phase2 $phase2 not understood. Your choices are ah and esp.\n";
	}
	print "\tauto=ignore\n";
	print "\talso=main\n";
	print "\n";
}
