/*
 * DNS KEY lookup global definitions
 * Copyright (C) 2002 Michael Richardson <mcr@freeswan.org>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#ifndef POLLIN
#include <poll.h>
#endif

#include "freeswan.h"

/*
 * a base-64 encoded 2192 bit key takes:
 *   2192/8 * 4/3 = 365 bytes.
 *
 * a base-64 encoded 16384 bit key takes:
 *   16384/8*4/3  = 2730 bytes.
 *
 * so, we pick 4096 bytes as the maximum.
 *
 * Note that TXT records may have an introducer (X-IPsec) and an ID which
 * is either an IP address or @FQDN that preceeds the base64 encoded key.
 *
 */


typedef struct dnskey_glob {
	int debug;
	int prompt;
	int concurrent;
	int done;
        int regress;                  /* if 1, then we are doing regression testing */
	struct pollfd   l_fds[256];   /* array of input sources */
	int             l_nfds;       /* number of relevant entries */
	int             cmdloc;
	unsigned char   cmdbuf[LWDNSQ_CMDBUF_LEN];
	FILE           *cmdproto_out;
} dnskey_glob;

extern void lookup_key(dnskey_glob *gs,int, char **);
extern void lookup_key4(dnskey_glob *gs,int, char **);
extern void lookup_key6(dnskey_glob *gs,int, char **);
extern void lookup_txt(dnskey_glob *gs,int, char **);
extern void lookup_txt4(dnskey_glob *gs,int, char **);
extern void lookup_txt6(dnskey_glob *gs,int, char **);
extern void lookup_ipseckey(dnskey_glob *gs,int, char **);
extern void lookup_ipseckey4(dnskey_glob *gs,int, char **);
extern void lookup_ipseckey6(dnskey_glob *gs,int, char **);
extern void lookup_oe4(dnskey_glob *gs,int, char **);
extern void lookup_oe6(dnskey_glob *gs,int, char **);
extern void lookup_a(dnskey_glob *gs,int, char **);
extern void lookup_aaaa(dnskey_glob *gs,int, char **);

/*
 *
 * Local variables:
 * c-file-style: "linux"
 * c-basic-offset: 2
 * End:
 *
 */
