Summary: Point-to-Point Tunneling Protocol (PPTP) Client GUI
Name: pptp-php-gtk
Provides: pptp-php-gtk
Version: 20040605
Release: rc1
Source: pptp-php-gtk-20040605.tar.gz
Source1: php-4.3.0.tar.bz2
Source2: php-gtk-0.5.2.tar.bz2
Patch: pptp-php-gtk-20030107.patch
Copyright: GPL
Group: Applications/Internet
Vendor: Hewlett-Packard
Packager: James Cameron <james.cameron@hp.com>
Distribution: PPTP Client Project
Requires: ppp >= 2.4.2
Requires: pptp-linux >= 1.2.0
Requires: iproute
Buildroot: %{_tmppath}/%{name}-%{version}-buildroot

%description
Graphical user interface for PPTP Client.
See http://quozl.netrek.org/pptp/php-gtk/
Supports configuration of tunnels, starting, stopping, catching debug
output from pppd, DNS and routing changes.

%changelog
* Tue Apr 08 2003 James Cameron <quozl@us.netrek.org>
- fix link to pptpconfig.

* Tue Jan 07 2003 James Cameron <quozl@us.netrek.org>
- fix path to XML file; my test machine had it in my default directory.
- new upstream release.

* Mon Jan 06 2003 James Cameron <quozl@us.netrek.org>
- first package attempt, with assistance from Bob Tanner

%prep
%setup -D -a 1 -a 2
# %patch -p1

%build
#
# <quandry>
# - package needs a special build of php (--enable-pcntl issue)
# - package needs a special build of php-gtk (to use the above php)
# - everything needs to be in one binary package (for acceptability)
# - build of php-gtk depends on the installed special build of php
# </quandry>
#
# <solution-number-one>
# - build as root, constructing /usr/lib/pptp-php-gtk as we go
# - (this is how this spec file currently does it)
# </solution-number-one>
#
# <solution-number-two>
# - break into three packages for build purposes only
# - build php into /usr/lib/pptp-php-gtk and install on build system
# - build php-gtk into /usr/lib/pptp-php-gtk and install on build system
# - build pptp-php-gtk and grab a copy of /usr/lib/pptp-php-gtk
# </solution-number-two>
#
# <solution-number-three>
# - break into three packages anyway as above
# - write a spec file that will pull all three packages into one
# </solution-number-three>
#
mkdir -p %{_libdir}/pptp-php-gtk
# known build dependencies; libglade
# make
pushd php-4.3.0
./configure --prefix=%{_libdir}/pptp-php-gtk/php \
    --disable-cgi \
    --disable-rpath \
    --disable-ipv6 \
    --disable-all \
    --enable-pcntl \
    --enable-posix \
    --disable-xml \
    --disable-safe-mode \
    --disable-sigchild \
    --disable-bcmath \
    --disable-calendar \
    --disable-ctype \
    --disable-dba \
    --disable-dbase \
    --disable-dbx \
    --disable-dio \
    --disable-exit \
    --disable-filepro \
    --disable-ftp \
    --disable-gd-native-ttf \
    --disable-mbstring \
    --disable-mbregex \
    --disable-mime-magic \
    --disable-overload \
    --disable-session \
    --disable-shmop \
    --disable-ucd-snmp-hack \
    --disable-sockets \
    --disable-sysvmsg \
    --disable-sysvsem \
    --disable-sysvshm \
    --disable-wddx \
    --disable-xml \
    --disable-xslt \
    --disable-yp \
    --without-bz2 \
    --without-db3 \
    --without-curl \
    --without-gd \
    --without-ttf \
    --without-gdbm \
    --without-gettext \
    --without-ncurses \
    --without-gmp \
    --without-iconv \
    --without-jpeg \
    --without-mm \
    --without-openssl \
    --without-png \
    --without-pspell \
    --without-xml \
    --without-zlib \
    --without-imap \
    --without-kerberos \
    --without-ldap \
    --without-mysql \
    --without-pgsql \
    --without-snmp \
    --without-unixODBC \
    --without-mnogosearch \
    --with-pcre-regex=yes
make %{?_smp_mflags}
%makeinstall
# hack, do install to an executable location we can use for php-gtk below
# user performing build will need ownership of /usr/lib/pptp-php-gtk
make install DESTDIR=/usr/lib/pptp-php-gtk/php
pwd
popd
pushd php-gtk-0.5.2
PATH=$PATH:$RPM_BUILD_ROOT/usr/bin:$RPM_BUILD_ROOT/usr/lib/pptp-php-gtk/php/bin/ ./buildconf
PATH=$PATH:$RPM_BUILD_ROOT/usr/bin:$RPM_BUILD_ROOT/usr/lib/pptp-php-gtk/php/bin/ ./configure \
    --prefix=%{_libdir}/pptp-php-gtk/php-gtk \
    --with-php-config=%{_libdir}/pptp-php-gtk/php/bin/php-config \
    --disable-combobutton \
    --disable-gdk_pixbuftest \
    --disable-gtktest \
    --disable-piemenu \
    --disable-scrollpane \
    --disable-spaned \
    --disable-sqpane
make
make %{?_smp_mflags}
%makeinstall
pwd
popd

%install
# %makeinstall  DESTDIR=%{buildroot}
rm -f %{buildroot}/usr/bin/pptpconfig
mkdir -p %{buildroot}/etc/pptp-php-gtk
mkdir -p %{buildroot}/usr/lib/pptp-php-gtk
mkdir -p %{buildroot}/usr/bin
cp pptp-php-gtk.xml %{buildroot}/usr/lib/pptp-php-gtk/
cp pptp-php-gtk.php %{buildroot}/usr/bin/
cp pixmaps/*.xpm %{buildroot}/usr/lib/pptp-php-gtk/
# hack, replicate php and php-gtk into buildroot
(cd /usr/lib;tar cf - pptp-php-gtk) | (cd %{buildroot}/usr/lib;tar xf -)

%clean
[ -n "%{buildroot}" -a "%{buildroot}" != / ] && rm -rf %{buildroot}
rm -rf /usr/lib/pptp-php-gtk/*

%post
ln -sf /usr/bin/pptp-php-gtk.php /usr/sbin/pptpconfig
ln -sf /usr/bin/consolehelper /usr/bin/pptpconfig
cat > /etc/pam.d/pptpconfig  << EOF
#%PAM-1.0
auth       sufficient   /lib/security/pam_rootok.so
auth       sufficient   /lib/security/pam_timestamp.so
auth       required     /lib/security/pam_stack.so service=system-auth
session    required     /lib/security/pam_permit.so
session    optional     /lib/security/pam_xauth.so
session    optional     /lib/security/pam_timestamp.so
account    required     /lib/security/pam_permit.so
EOF
cat > /etc/security/console.apps/pptpconfig << EOF
USER=root
PROGRAM=/usr/sbin/pptpconfig
SESSION=true
EOF

%postun
rm -f /usr/bin/pptpconfig /usr/sbin/pptpconfig

%files
%defattr(0644,root,root)
%doc TODO
/usr/lib/pptp-php-gtk/pptp-php-gtk.xml
/usr/lib/pptp-php-gtk/php/lib/php/extensions/no-debug-non-zts-20020429/php_gtk.so
/usr/lib/pptp-php-gtk/*.xpm
%defattr(0755,root,root)
/usr/lib/pptp-php-gtk/php/bin/php
/usr/bin/pptp-php-gtk.php
%dir /etc/pptp-php-gtk
%dir /usr/lib/pptp-php-gtk
/usr/share/applications/pptp-php-gtk.desktop
