&nbsp;<br />
<b><big>Features</big></b>
<br />&nbsp;<br />
- Normal conferencing services such as private messages, channels, 
channel messages, etc. All traffic is secured and authenticated.

<br />&nbsp;<br />
- No unique nicknames. There can be same nicknames in SILC without 
collisions. SILC has unique Client ID's, Server ID's and Channel ID's to 
assure that there are no collisions. The maximum length of the nickname 
is 128 characters. The maximum length of the channel name is 256 characters.

<br />&nbsp;<br />
- Channels can have channel operators and a channel founder which is the 
client who created the channel. Channel founder privileges supersedes the 
channel operator privileges. Also, channel founder privileges may be 
regained even if the founder leaves the channel. The requirement for this 
is that the client is connected to the same server it was originally 
connected. The channel founder cannot be removed (kicked) from the 
channel using force.

<br />&nbsp;<br />
- Channel messages are protected by channel key, generated by the server. 
The key is re-generated once in an hour. It is possible to set a private 
key for the channel so that even the servers does not know the key. 
Actually, it is possible to set several private keys so that only 
specific users on the channel may decrypt some specific messages. Adding 
the private key significantly increases the security as nobody else but 
the users on the channel know the key.

<br />&nbsp;<br />
- Private messages are protected using session keys, generated when 
connecting to the server. This means that the private messages are 
decrypted and re-encrypted enroute to the true receiver of the message. 
However, it is possible to set a private key between two clients and 
protect the private messages with that key. In this case no server 
enroute can decrypt the message since they don't have the key. The SILC 
protocol provides an automatic key negotiation between two clients using 
the SKE protocol. This makes it very easy to negotiate a shared secret 
key with another client in the network.

<br />&nbsp;<br />
- All the other traffic, like commands between client and the server are 
protected using the session keys. Session keys are re-generated once in 
an hour. The re-key may be done with or without the PFS (Perfect Forward 
Secrecy).

<br />&nbsp;<br />
- Secure key exchange and authentication protocol. SILC Key Exchange 
(SKE) protocol provides key material used in the SILC sessions in secure 
manner. The protocol is immune for example to man-in-the-middle attacks 
and is based on the Diffie-Hellman key exchange algorithm. The SILC 
Authentication protocol provides strong authentication. Authentication 
may be based on passphrase or public key (RSA) authentication. For 
clients there is an option not to use authentication when connecting to 
servers.

<br />&nbsp;<br />
- Supports secure file transferring between clients in the network.  SILC 
use the SFTP as the main file transfer protocol.

<br />&nbsp;<br />
- All traffic is encrypted and authenticated using the best cryptographic 
algorithms out there. Cipher keys are, by default, 256 bits in length and 
public keys, by default, 1024 bits in length.

<br />&nbsp;<br />
- Supports the following ciphers: AES(Rijndael), Twofish, Blowfish, Mars, 
Cast-256, RC5 and RC6. Supports the following hash functions: MD5 and 
SHA1. Supports the following HMACs: hmac-sha1-96, hmac-md5-96, 
hmac-sha1 and hmac-md5. Supports the PKCS #1 (RSA) for public key 
cryptography. 

<br />&nbsp;<br />
- Supports data compression with GZIP to improve performance.

<br />&nbsp;<br />
- Supports SOCKS4 and SOCKS5 firewall traversal protocols.

<br />&nbsp;<br />
- SIM (SILC Module) support. Support for loading of shared objects at 
run-time that provides new and extended features to both SILC client and 
server. These can provide extra ciphers and extra features to the software.

<br />&nbsp;<br />
- SILC client can be installed and used without root privileges.

<br />&nbsp;<br />
- SILC client can be configured by system wide configuration files but 
with user specific configuration files as well.
