/*
 *	SILCCommandPayload.java		2002/11/15
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.*;
import java.security.SecureRandom;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import com.alistairphipps.util.Hex;

/** Class to implement a Command payload
 *
 * @author Alistair K Phipps
 * @version 20021115
 */
public class SILCCommandPayload extends SILCPayload
{ // TODO
	byte _yCommandType;
	SILCArgumentPayload[] _argl;
	short _sCommandId;
	static short s_sCommandSendId = 0;

	/** Constructor to set up the payload with specified values.
	 */
	public SILCCommandPayload( byte yCommandType, SILCArgumentPayload[] argl ) 
	{
		_yCommandType = yCommandType;
		_argl = argl;
	}

	/** Constructor to set up the payload information from a bytelist - the decrypted payload information received in a packet.
	 * @param yl List of bytes forming received payload
	 */
	public SILCCommandPayload( byte[] yl )
	{
		ByteBuffer yb = ByteBuffer.wrap( yl );
		short sPayloadLength = yb.getShort();
		assert( ( sPayloadLength & 0xFFFF ) == yl.length );
		_yCommandType = yb.get();
		// System.out.println("Command type: "+SILCCommandType.toString(_yCommandType));
		byte yNumArgs = yb.get();
		// System.out.println("Number of arguments: "+String.valueOf(yNumArgs & 0xFF));
		_sCommandId = yb.getShort();
		// System.out.println("Command Id: "+String.valueOf(_sCommandId & 0xFF));
		_argl = new SILCArgumentPayload[ yNumArgs & 0xFF ];
		for( int i = 0; i < ( yNumArgs & 0xFF ); i++ )
		{
			// System.out.println("Reading argument:"+String.valueOf(i));
			int iArgStart = yb.position();
			short sArgLength = yb.getShort();
			sArgLength+=3;
			
			// System.out.println("Argument Payload full length: "+String.valueOf(sArgLength & 0xFFFF));
			byte[] ylArg = new byte[ sArgLength & 0xFFFF ];
			yb.position( iArgStart );
			yb.get( ylArg );

			_argl[i] = new SILCArgumentPayload( ylArg );

			if( i < ( ( yNumArgs & 0xFF ) - 1 ) ) // if we're not on the last arg
				yb.position( iArgStart + ( sArgLength & 0xFFFF ) );
		}
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		int iLength = 6; // length of this payload without args
		for( int i = 0; i < _argl.length; i++ )
			iLength += _argl[i].toByteList().length;

		byte[] ylRet = new byte[ iLength ];
		ByteBuffer yb = ByteBuffer.wrap( ylRet );
		yb.putShort( (short)iLength );
		yb.put( _yCommandType );
		yb.put( (byte)_argl.length );
		yb.putShort( s_sCommandSendId++ ); // put seq num and increment
		for( int i = 0; i < _argl.length; i++ )
			yb.put( _argl[i].toByteList() );

		return yb.array();
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Command type: " + SILCCommandType.toString( _yCommandType );
		strRet += "\nId: " + Short.toString( _sCommandId );
		strRet += "\nArgument list: ";
		for( int i = 0; i < _argl.length; i++ )
			strRet += "\n    " + _argl[i].toString();
		return strRet;
	}

	public SILCArgumentPayload[] getArgList()
	{
		return _argl;
	}

	public boolean isList()
	{
		return false; // XXX need to set this based on status_list_start etc
	}
}
