/*
 *	SILCNotifyPayload.java		2002/11/14
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.*;
import java.security.SecureRandom;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import com.alistairphipps.util.Hex;

/** Class to implement a Notify payload
 *
 * @author Alistair K Phipps
 * @version 20021115
 */
public class SILCNotifyPayload extends SILCPayload
{
	short _sNotifyType;
	SILCArgumentPayload[] _argl;

	/** Constructor to set up the payload with specified values.
	 */
	public SILCNotifyPayload( short sNotifyType, SILCArgumentPayload[] argl ) 
	{
		_sNotifyType = sNotifyType;
		_argl = argl;
	}

	/** Constructor to set up the payload information from a bytelist - the decrypted payload information received in a packet.
	 * @param yl List of bytes forming received payload
	 */
	public SILCNotifyPayload( byte[] yl )
	{
		ByteBuffer yb = ByteBuffer.wrap( yl );
		_sNotifyType = yb.getShort();
		short sPayloadLength = yb.getShort();
		assert( ( sPayloadLength & 0xFFFF ) == yl.length );
		byte yNumArgs = yb.get();
		_argl = new SILCArgumentPayload[ yNumArgs & 0xFF ];
		for( int i = 0; i < ( yNumArgs & 0xFF ); i++ )
		{
			int iArgStart = yb.position();
			short sArgLength = yb.getShort();
			byte[] ylArg = new byte[ sArgLength+3 & 0xFFFF ];
			//System.out.println("Argument length: "+sArgLength);
			yb.position( iArgStart );
			yb.get( ylArg );
			_argl[i] = new SILCArgumentPayload( ylArg );
			if( i < ( ( yNumArgs & 0xFF ) - 1 ) ) // if we're not on the last arg
				yb.position( iArgStart + ( sArgLength & 0xFFFF ) );
		}
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		int iLength = 6; // length of this payload without args
		for( int i = 0; i < _argl.length; i++ )
			iLength += _argl[i].toByteList().length;

		byte[] ylRet = new byte[ iLength ];
		ByteBuffer yb = ByteBuffer.wrap( ylRet );
		yb.putShort( _sNotifyType );
		yb.putShort( (short)iLength );
		yb.putShort( (short)_argl.length );
		for( int i = 0; i < _argl.length; i++ )
			yb.put( _argl[i].toByteList() );

		return yb.array();
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Notify type: " + SILCNotifyType.toString( _sNotifyType );
		strRet += "\nArgument list: ";
		
		/*
		switch( _sNotifyType)
		{
		case SILCNotifyType.NONE:
			for( int i = 0; i < _argl.length; i++ )
			{
				strRet += "\n    " + hexToString(_argl[i].getData());
				System.out.println( hexToString(_argl[i].getData()) );
			}
			break;
		case SILCNotifyType.MOTD:
			for( int i = 0; i < _argl.length; i++ )
			{
				strRet += "\n    " + hexToString(_argl[i].getData());
				System.out.println( hexToString(_argl[i].getData()) );
			}
			break;
		default:
		*/
		for( int i = 0; i < _argl.length; i++ )
			strRet += "\n    " + _argl[i].toString();
		// }
		return strRet;
	}
	private String hexToString(byte[] yb)
	{
		ByteBuffer ya = ByteBuffer.wrap( yb );
		String strRet = s_csUTF8.decode( ya ).toString();
		return strRet;
	}
	public boolean isNone()
	{
		if (_sNotifyType == SILCNotifyType.NONE)
			return true;
		return false;
	}

	public boolean isMOTD()
	{
		if (_sNotifyType == SILCNotifyType.MOTD)
			return true;
		return false;
	}

	public boolean isList()
	{
		return false; // XXX need to set this based on status_list_start etc
	}
	public String getArgumentData()
	{
		String strRet="";
		for( int i = 0; i < _argl.length; i++ )
		{
			strRet += "\n    " + hexToString(_argl[i].getData());
			// System.out.println( hexToString(_argl[i].getData()) );
		}
		return strRet;
	}
}
