/*
 *	SwingUIHandler.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.swingui;

import com.alistairphipps.jsilc.core.*;

/** 
 * The SwingUIHandler implements the UI handler for output via Swing widgets
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public class SwingUIHandler implements UIHandler
{
	private MainFrame _mainFrame;

	private OutEvent _outEvent;	// FIXME: should do a queue - currently can lose events
	
	public SwingUIHandler()
	{
		_mainFrame = new MainFrame( this ); // send our reference for callbacks
	}
	
	public void putEvent( InEvent event )
	{
		if( event instanceof MessageInEvent )
			_mainFrame.outputMessage( event.getSource(), ((MessageInEvent)event).getMessage() );
	}

	public synchronized OutEvent getEvent()
	{
		try
		{
			wait();				// wait for callback
		}
		catch( InterruptedException e )
		{
			return null;
		}
		return _outEvent;
	}

	/** callback function to connect to a server */
	synchronized void connect( String strUsername, String strHost, int iPort )
	{
		_outEvent = new ConnectOutEvent( strUsername, strHost, iPort );
		notify();
	}

	/** callback function to disconnect from a server */
	synchronized void disconnect()
	{
		_outEvent = new DisconnectOutEvent();
		notify();
	}

	/** callback function to send a message */
	synchronized void sendMessage( Entity dest, String strMessage )
	{
		_outEvent = new MessageOutEvent( dest, strMessage );
		notify();
	}	
}
