/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ContentEncryptionAlgorithmIdentifier
extends CMSObject {
    private AlgorithmIdentifier alg;

    public ContentEncryptionAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public ContentEncryptionAlgorithmIdentifier(ASN1Sequence aSN1Sequence) {
        this(new AlgorithmIdentifier(aSN1Sequence));
    }

    public ContentEncryptionAlgorithmIdentifier(ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier) {
        this.alg = contentEncryptionAlgorithmIdentifier.alg;
    }

    public ContentEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this(new AlgorithmIdentifier(dERObjectIdentifier));
    }

    public ContentEncryptionAlgorithmIdentifier(String string) {
        this(new AlgorithmIdentifier(new DERObjectIdentifier(string)));
    }

    public ContentEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this(new AlgorithmIdentifier(dERObjectIdentifier, dERObject));
    }

    public static ContentEncryptionAlgorithmIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new ContentEncryptionAlgorithmIdentifier(AlgorithmIdentifier.getInstance(aSN1TaggedObject, bl));
    }

    public static ContentEncryptionAlgorithmIdentifier getInstance(Object object) {
        if (object == null || object instanceof ContentEncryptionAlgorithmIdentifier) {
            return (ContentEncryptionAlgorithmIdentifier)object;
        }
        return new ContentEncryptionAlgorithmIdentifier(AlgorithmIdentifier.getInstance(object));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }
}

