/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class DigestAlgorithmIdentifier
extends CMSObject {
    private AlgorithmIdentifier alg;

    public DigestAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public DigestAlgorithmIdentifier(ASN1Sequence aSN1Sequence) {
        this(new AlgorithmIdentifier(aSN1Sequence));
    }

    public DigestAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this(new AlgorithmIdentifier(dERObjectIdentifier));
    }

    public DigestAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this(new AlgorithmIdentifier(dERObjectIdentifier, dERObject));
    }

    public DigestAlgorithmIdentifier(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.alg = digestAlgorithmIdentifier.alg;
    }

    public DigestAlgorithmIdentifier(String string) {
        this(new DERObjectIdentifier(string));
    }

    public static DigestAlgorithmIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new DigestAlgorithmIdentifier(AlgorithmIdentifier.getInstance(aSN1TaggedObject, bl));
    }

    public static DigestAlgorithmIdentifier getInstance(Object object) {
        if (object == null || object instanceof DigestAlgorithmIdentifier) {
            return (DigestAlgorithmIdentifier)object;
        }
        return new DigestAlgorithmIdentifier(AlgorithmIdentifier.getInstance(object));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }
}

