/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.Digest;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.EncapsulatedContentInfo;

public class DigestedData
extends CMSObject {
    private CMSVersion version;
    private DigestAlgorithmIdentifier digestAlgorithm;
    private EncapsulatedContentInfo encapContentInfo;
    private Digest digest;

    public DigestedData(DigestAlgorithmIdentifier digestAlgorithmIdentifier, EncapsulatedContentInfo encapsulatedContentInfo, Digest digest) {
        this.setDigestAlgorithm(digestAlgorithmIdentifier);
        this.setEncapContentInfo(encapsulatedContentInfo);
        this.setDigest(digest);
        this.setVersion();
    }

    public DigestedData(ASN1Sequence aSN1Sequence) {
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(0));
        this.digestAlgorithm = DigestAlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.encapContentInfo = EncapsulatedContentInfo.getInstance(aSN1Sequence.getObjectAt(2));
        this.digest = Digest.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public DigestedData(DigestedData digestedData) {
        this.version = digestedData.version;
        this.digestAlgorithm = digestedData.digestAlgorithm;
        this.encapContentInfo = digestedData.encapContentInfo;
        this.digest = digestedData.digest;
    }

    public static DigestedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DigestedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DigestedData getInstance(Object object) {
        if (object == null || object instanceof DigestedData) {
            return (DigestedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DigestedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid DigestedData: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public DigestAlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.digestAlgorithm);
        bERConstructedSequence.addObject(this.encapContentInfo);
        bERConstructedSequence.addObject(this.digest);
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        if (this.encapContentInfo.getContentType().getContentType().equals(CMSObjectIdentifiers.id_data.getId())) {
            this.setVersion(new CMSVersion(new BigInteger("0")));
        } else {
            this.setVersion(new CMSVersion(new BigInteger("2")));
        }
    }

    private void setDigestAlgorithm(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.digestAlgorithm = digestAlgorithmIdentifier;
    }

    private void setEncapContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.encapContentInfo = encapsulatedContentInfo;
    }

    private void setDigest(Digest digest) {
        this.digest = digest;
    }
}

