/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.ContentType;

public class EncapsulatedContentInfo
extends CMSObject {
    private ContentType eContentType;
    private ASN1OctetString eContent;

    public EncapsulatedContentInfo(ContentType contentType, byte[] byArray) {
        this.setContentType(contentType);
        this.setContent(byArray);
    }

    public EncapsulatedContentInfo(ASN1Sequence aSN1Sequence) {
        this.eContentType = ContentType.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.getSize() > 1) {
            this.eContent = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        }
    }

    public EncapsulatedContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.eContentType = encapsulatedContentInfo.eContentType;
        this.eContent = encapsulatedContentInfo.eContent;
    }

    public static EncapsulatedContentInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return EncapsulatedContentInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static EncapsulatedContentInfo getInstance(Object object) {
        if (object == null || object instanceof EncapsulatedContentInfo) {
            return (EncapsulatedContentInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new EncapsulatedContentInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid EncapsulatedContentInfo: " + object.getClass().getName());
    }

    public byte[] getContentBytes() {
        return this.eContent.getOctets();
    }

    public ASN1OctetString getContent() {
        return this.eContent;
    }

    public ContentType getContentType() {
        return this.eContentType;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.eContentType);
        if (this.eContent != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(true, 0, this.eContent));
        }
        return bERConstructedSequence;
    }

    private void setContent(byte[] byArray) {
        this.eContent = byArray == null ? null : new BERConstructedOctetString(byArray);
    }

    private void setContentType(ContentType contentType) {
        this.eContentType = contentType;
    }
}

