/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.UnprotectedAttributes;

public class EncryptedData
extends CMSObject {
    private CMSVersion version;
    private EncryptedContentInfo encryptedContentInfo;
    private UnprotectedAttributes unprotectedAttrs;

    public EncryptedData(EncryptedContentInfo encryptedContentInfo, UnprotectedAttributes unprotectedAttributes) {
        this.setEncryptedContentInfo(encryptedContentInfo);
        this.setUnprotectedAttrs(unprotectedAttributes);
        this.setVersion();
    }

    public EncryptedData(ASN1Sequence aSN1Sequence) {
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(0));
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.getSize() > 2) {
            this.unprotectedAttrs = UnprotectedAttributes.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(2), false);
        }
    }

    public EncryptedData(EncryptedData encryptedData) {
        this.version = encryptedData.version;
        this.encryptedContentInfo = encryptedData.encryptedContentInfo;
        this.unprotectedAttrs = encryptedData.unprotectedAttrs;
    }

    public static EncryptedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return EncryptedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static EncryptedData getInstance(Object object) {
        if (object == null || object instanceof EncryptedData) {
            return (EncryptedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new EncryptedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid EncryptedData: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public UnprotectedAttributes getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.unprotectedAttrs.getDERObject()));
        }
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        this.setVersion(new CMSVersion(new BigInteger(this.unprotectedAttrs == null ? "0" : "2")));
    }

    private void setEncryptedContentInfo(EncryptedContentInfo encryptedContentInfo) {
        this.encryptedContentInfo = encryptedContentInfo;
    }

    private void setUnprotectedAttrs(UnprotectedAttributes unprotectedAttributes) {
        this.unprotectedAttrs = unprotectedAttributes;
    }
}

