/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKeys;
import org.bouncycastle.asn1.cms.UserKeyingMaterial;

public class KeyAgreeRecipientInfo
extends CMSObject {
    private CMSVersion version;
    private OriginatorIdentifierOrKey originator;
    private UserKeyingMaterial ukm;
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
    private RecipientEncryptedKeys recipientEncryptedKeys;

    public KeyAgreeRecipientInfo(OriginatorIdentifierOrKey originatorIdentifierOrKey, UserKeyingMaterial userKeyingMaterial, KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier, RecipientEncryptedKeys recipientEncryptedKeys) {
        this.setOriginator(originatorIdentifierOrKey);
        this.setUserKeyingMaterial(userKeyingMaterial);
        this.setKeyEncryptionAlgorithm(keyEncryptionAlgorithmIdentifier);
        this.setRecipientEncryptedKeys(recipientEncryptedKeys);
        this.setVersion();
    }

    public KeyAgreeRecipientInfo(ASN1Sequence aSN1Sequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(n++));
        block0 : switch (aSN1Sequence.getSize()) {
            case 3: {
                break;
            }
            case 4: {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n++);
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.originator = OriginatorIdentifierOrKey.getInstance(aSN1TaggedObject, true);
                        break block0;
                    }
                    case 1: {
                        this.ukm = UserKeyingMaterial.getInstance(aSN1TaggedObject, true);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid KeyAgreeRecipientInfo. Tag number out of range: " + aSN1TaggedObject.getTagNo());
            }
            case 5: {
                this.originator = OriginatorIdentifierOrKey.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n++), true);
                this.ukm = UserKeyingMaterial.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n++), true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid KeyAgreeRecipientInfo. Bad sequence.");
            }
        }
        this.keyEncryptionAlgorithm = KeyEncryptionAlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n++));
        this.recipientEncryptedKeys = RecipientEncryptedKeys.getInstance(aSN1Sequence.getObjectAt(n++));
    }

    public KeyAgreeRecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.version = keyAgreeRecipientInfo.version;
        this.originator = keyAgreeRecipientInfo.originator;
        this.ukm = keyAgreeRecipientInfo.ukm;
        this.keyEncryptionAlgorithm = keyAgreeRecipientInfo.keyEncryptionAlgorithm;
        this.recipientEncryptedKeys = keyAgreeRecipientInfo.recipientEncryptedKeys;
    }

    public static KeyAgreeRecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KeyAgreeRecipientInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static KeyAgreeRecipientInfo getInstance(Object object) {
        if (object == null || object instanceof KeyAgreeRecipientInfo) {
            return (KeyAgreeRecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new KeyAgreeRecipientInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientInfo: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.originator;
    }

    public UserKeyingMaterial getUserKeyingMaterial() {
        return this.ukm;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public RecipientEncryptedKeys getRecipientEncryptedKeys() {
        return this.recipientEncryptedKeys;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(new BERTaggedObject(true, 0, this.originator.getDERObject()));
        if (this.ukm != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(true, 1, this.ukm.getDERObject()));
        }
        bERConstructedSequence.addObject(this.keyEncryptionAlgorithm);
        bERConstructedSequence.addObject(this.recipientEncryptedKeys);
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        this.setVersion(new CMSVersion(new BigInteger("3")));
    }

    private void setOriginator(OriginatorIdentifierOrKey originatorIdentifierOrKey) {
        this.originator = originatorIdentifierOrKey;
    }

    private void setUserKeyingMaterial(UserKeyingMaterial userKeyingMaterial) {
        this.ukm = userKeyingMaterial;
    }

    private void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithmIdentifier;
    }

    private void setRecipientEncryptedKeys(RecipientEncryptedKeys recipientEncryptedKeys) {
        this.recipientEncryptedKeys = recipientEncryptedKeys;
    }
}

