/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class MessageAuthenticationCode
extends CMSObject {
    private ASN1OctetString mac;

    public MessageAuthenticationCode(byte[] byArray) {
        this.setMac(byArray);
    }

    public MessageAuthenticationCode(ASN1OctetString aSN1OctetString) {
        this.mac = aSN1OctetString;
    }

    public MessageAuthenticationCode(MessageAuthenticationCode messageAuthenticationCode) {
        this.mac = messageAuthenticationCode.mac;
    }

    public static MessageAuthenticationCode getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return MessageAuthenticationCode.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static MessageAuthenticationCode getInstance(Object object) {
        if (object == null || object instanceof MessageAuthenticationCode) {
            return (MessageAuthenticationCode)object;
        }
        if (object instanceof ASN1OctetString) {
            return new MessageAuthenticationCode((ASN1OctetString)object);
        }
        throw new IllegalArgumentException("Invalid MessageAuthenticationCode: " + object.getClass().getName());
    }

    public byte[] getMac() {
        return this.mac.getOctets();
    }

    public DERObject getDERObject() {
        return this.mac;
    }

    private void setMac(byte[] byArray) {
        this.mac = new BERConstructedOctetString(byArray);
    }
}

