/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CertificateRevocationLists;
import org.bouncycastle.asn1.cms.CertificateSet;

public class OriginatorInfo
extends CMSObject {
    private CertificateSet certs;
    private CertificateRevocationLists crls;

    public OriginatorInfo(CertificateSet certificateSet, CertificateRevocationLists certificateRevocationLists) {
        this.setCertificates(certificateSet);
        this.setCrls(certificateRevocationLists);
    }

    public OriginatorInfo(ASN1Sequence aSN1Sequence) {
        block0 : switch (aSN1Sequence.getSize()) {
            case 0: {
                break;
            }
            case 1: {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(0);
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.certs = CertificateSet.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                    case 1: {
                        this.crls = CertificateRevocationLists.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid OriginatorInfo -- Bad tag: " + aSN1TaggedObject.getTagNo());
            }
            case 2: {
                this.certs = CertificateSet.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), false);
                this.crls = CertificateRevocationLists.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid OriginatorInfo");
            }
        }
    }

    public OriginatorInfo(OriginatorInfo originatorInfo) {
        this.certs = originatorInfo.certs;
        this.crls = originatorInfo.crls;
    }

    public static OriginatorInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return OriginatorInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static OriginatorInfo getInstance(Object object) {
        if (object == null || object instanceof OriginatorInfo) {
            return (OriginatorInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new OriginatorInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid OriginatorInfo: " + object.getClass().getName());
    }

    public CertificateSet getCertificates() {
        return this.certs;
    }

    public CertificateRevocationLists getCrls() {
        return this.crls;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        if (this.certs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.certs.getDERObject()));
        }
        if (this.crls != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.crls.getDERObject()));
        }
        return bERConstructedSequence;
    }

    private void setCertificates(CertificateSet certificateSet) {
        this.certs = certificateSet;
    }

    private void setCrls(CertificateRevocationLists certificateRevocationLists) {
        this.crls = certificateRevocationLists;
    }
}

