/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class RC2CBCParameter
extends CMSObject {
    private DERInteger rc2ParameterVersion;
    private ASN1OctetString iv;

    public RC2CBCParameter(BigInteger bigInteger, byte[] byArray) {
        this.setRc2ParameterVersion(bigInteger);
        this.setIv(byArray);
    }

    public RC2CBCParameter(ASN1Sequence aSN1Sequence) {
        this.rc2ParameterVersion = (DERInteger)aSN1Sequence.getObjectAt(0);
        this.iv = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
    }

    public RC2CBCParameter(RC2CBCParameter rC2CBCParameter) {
        this.rc2ParameterVersion = rC2CBCParameter.rc2ParameterVersion;
        this.iv = rC2CBCParameter.iv;
    }

    public static RC2CBCParameter getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RC2CBCParameter.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RC2CBCParameter getInstance(Object object) {
        if (object == null || object instanceof RC2CBCParameter) {
            return (RC2CBCParameter)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RC2CBCParameter((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid RC2CBCParameter: " + object.getClass().getName());
    }

    public BigInteger getRc2ParameterVersion() {
        return this.rc2ParameterVersion.getValue();
    }

    public byte[] getIv() {
        return this.iv.getOctets();
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.rc2ParameterVersion);
        bERConstructedSequence.addObject(this.iv);
        return bERConstructedSequence;
    }

    private void setRc2ParameterVersion(BigInteger bigInteger) {
        this.rc2ParameterVersion = new DERInteger(bigInteger);
    }

    private void setIv(byte[] byArray) {
        this.iv = new BERConstructedOctetString(byArray);
    }
}

