/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.OtherKeyAttribute;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class RecipientKeyIdentifier
extends CMSObject {
    private SubjectKeyIdentifier subjectKeyIdentifier;
    private DERGeneralizedTime date;
    private OtherKeyAttribute other;

    public RecipientKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier, String string, OtherKeyAttribute otherKeyAttribute) {
        this.setSubjectKeyIdentifier(subjectKeyIdentifier);
        this.setDate(string);
        this.setOtherKeyAttribute(otherKeyAttribute);
    }

    public RecipientKeyIdentifier(ASN1Sequence aSN1Sequence) {
        this.subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        switch (aSN1Sequence.getSize()) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    this.date = (DERGeneralizedTime)aSN1Sequence.getObjectAt(1);
                }
                catch (Exception exception) {
                    this.other = OtherKeyAttribute.getInstance(aSN1Sequence.getObjectAt(2));
                }
                break;
            }
            case 3: {
                this.date = (DERGeneralizedTime)aSN1Sequence.getObjectAt(1);
                this.other = OtherKeyAttribute.getInstance(aSN1Sequence.getObjectAt(2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid KEKIdentifier");
            }
        }
    }

    public RecipientKeyIdentifier(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.subjectKeyIdentifier = recipientKeyIdentifier.subjectKeyIdentifier;
        this.date = recipientKeyIdentifier.date;
        this.other = recipientKeyIdentifier.other;
    }

    public static RecipientKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RecipientKeyIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RecipientKeyIdentifier getInstance(Object object) {
        if (object == null || object instanceof RecipientKeyIdentifier) {
            return (RecipientKeyIdentifier)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RecipientKeyIdentifier((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid RecipientKeyIdentifier: " + object.getClass().getName());
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public String getDate() {
        return this.date.getTime();
    }

    private void setDate(String string) {
        this.date = new DERGeneralizedTime(string);
    }

    public OtherKeyAttribute getOtherKeyAttribute() {
        return this.other;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.subjectKeyIdentifier);
        if (this.date != null) {
            bERConstructedSequence.addObject(this.date);
        }
        if (this.other != null) {
            bERConstructedSequence.addObject(this.other);
        }
        return bERConstructedSequence;
    }

    private void setSubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    private void setOtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        this.other = otherKeyAttribute;
    }
}

