/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class AESSICTest
implements Test {
    public String getName() {
        return "AESSIC";
    }

    private boolean sameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        try {
            Cipher cipher = Cipher.getInstance("AES/SIC/NoPadding", "BC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(Hex.decode("2B7E151628AED2A6ABF7158809CF4F3C"), "AES");
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(Hex.decode("F0F1F2F3F4F5F6F7F8F9FAFBFCFD0000")));
            byte[] byArray = cipher.doFinal(Hex.decode("00000000000000000000000000000000"));
            if (!this.sameAs(byArray, Hex.decode("E03EAD0935C95E80E166B16DD92B4EB4"))) {
                return new SimpleTestResult(false, this.getName() + ": AESSIC failed test 1");
            }
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(Hex.decode("F0F1F2F3F4F5F6F7F8F9FAFBFCFD0001")));
            byArray = cipher.doFinal(Hex.decode("00000000000000000000000000000000"));
            if (!this.sameAs(byArray, Hex.decode("D23513162B02D0F72A43A2FE4A5F97AB"))) {
                return new SimpleTestResult(false, this.getName() + ": AESSIC failed test 2");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": AESSIC failed " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        AESSICTest aESSICTest = new AESSICTest();
        TestResult testResult = aESSICTest.perform();
        System.out.println(testResult.toString());
    }
}

