/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CertPathBuilderTest
implements Test {
    public TestResult perform() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
            arrayList.add(x509Certificate);
            arrayList.add(x509Certificate2);
            arrayList.add(x509Certificate3);
            arrayList.add(x509CRL);
            arrayList.add(x509CRL2);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
            Calendar calendar = Calendar.getInstance();
            calendar.set(2002, 2, 21, 2, 21, 10);
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            hashSet.add(new TrustAnchor(x509Certificate, null));
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509Certificate3.getSubjectDN().getName());
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(hashSet, (CertSelector)x509CertSelector);
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setDate(calendar.getTime());
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "CertPathBuilder";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        CertPathBuilderTest certPathBuilderTest = new CertPathBuilderTest();
        TestResult testResult = certPathBuilderTest.perform();
        System.out.println(testResult.toString());
    }
}

