/*
 *	MessageInEvent.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.core;

/** 
 * The MessageInEvent class is an Event encapsulating a message received.
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public class MessageInEvent extends InEvent
{
	/** message to be received by the event */
	String _strMessage;
	
	/**
	 * Constructor sets up the source and message
	 * @param eSource source entity
	 * @param strMessage the message to send
	 */
	public MessageInEvent( Entity eSource, String strMessage )
	{
		super( eSource );	
		_strMessage = strMessage;
	}

	/** Retrieve the message
	 * @return message text
	 */
	public String getMessage()
	{
		return _strMessage;
	}
}
