/*
 *	Main.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.prototype;

import java.util.logging.*;
import com.alistairphipps.jsilc.core.*;
import com.alistairphipps.jsilc.silcprotocol.SILCConnectionHandler;
import com.alistairphipps.jsilc.swingui.SwingUIHandler;

/** 
 * Main class to instantiate a SwingUI
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public class Main
{
	/** logger is used for logging */
	private static Logger logger = Logger.getLogger( "com.alistairphipps.jsilc" );

	private static UIHandler ui;
	private static ConnectionHandler conn;
	
	/**
	 * main method performs the top-level program functions.
	 */
	public static void main( String[] strlArgs )
	{
		// set up the logger
		ConsoleHandler ch = new ConsoleHandler();
		ch.setLevel( Level.FINEST );
		logger.addHandler( ch );
		logger.setLevel( Level.FINEST );
		logger.setUseParentHandlers( false );
		logger.entering( "PrototypeMain", "main", strlArgs );
		try
		{
			// initialise connection to null
			conn = null;
			// create our UI - TODO: use a factory to create the UI and Connection handlers
			ui = new SwingUIHandler();

			// create thread for receiving events from connection and dispatching them to UI
			Thread t = new Thread()
			{
				public void run()
				{
					while( conn != null ) // if connection closed, conn = null, so exit loop and end thread
					{
						InEvent inev = conn.getEvent();	// will block
						ui.putEvent( inev );
					}
				}
			};

			// receive events from UI and dispatch them to connection
			while( true )
			{
				OutEvent outev = ui.getEvent();	// will block
				if( outev instanceof ConnectOutEvent )
				{
					conn = new SILCConnectionHandler( ( (ConnectOutEvent)outev ).getUsername(), ( (ConnectOutEvent)outev ).getHost(), ( (ConnectOutEvent)outev ).getPort() );
					t.start();
				}
				if( outev instanceof DisconnectOutEvent )
					conn = null;	// TODO: disconnect properly
				if( conn != null )
				{
					conn.putEvent( outev );
				}
			}
		}
		catch( Exception e )
		{
			logger.severe( "Caught exception: " + e.toString() );
			e.printStackTrace();
		}
		finally
		{
			logger.exiting( "PrototypeMain", "main" );
		}
	}
}
