/*
 *	SILCArgumentPayload.java		2002/11/15
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.*;
import java.security.SecureRandom;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import com.alistairphipps.util.Hex;

/** Class to implement an Argument payload
 *
 * @author Alistair K Phipps
 * @version 20021115
 */
public class SILCArgumentPayload extends SILCPayload
{
	byte _yArgType;
	byte[] _ylArgData;

	/** Constructor to set up the payload with specified values.
	 * @param yArgType Argument type
	 * @param ylArgData Byte list with argument data
	 */
	public SILCArgumentPayload( byte yArgType, byte[] ylArgData ) 
	{
		_yArgType = yArgType;
		_ylArgData = ylArgData;
	}

	/** Constructor to set up the payload information from a bytelist - the decrypted payload information received in a packet.
	 * @param yl List of bytes forming received payload
	 */
	public SILCArgumentPayload( byte[] yl )
	{
		ByteBuffer yb = ByteBuffer.wrap( yl );
		short sLength = yb.getShort();
		assert( ( sLength & 0xFFFF ) == ( yl.length ) );
		_yArgType = yb.get();
		_ylArgData = new byte[ ( sLength & 0xFFFF ) - 3 ];
		yb.get( _ylArgData );
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		ByteBuffer yb = ByteBuffer.allocate( 3 + _ylArgData.length );
		yb.putShort( (short)_ylArgData.length );
		yb.put( _yArgType );
		yb.put( _ylArgData );
		return yb.array();
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Arg type: " + Integer.toHexString( _yArgType & 0xFF );
		strRet += "  Arg Data: " + Hex.toString( _ylArgData );
		return strRet;
	}

	public byte getType()
	{
		return _yArgType;
	}
	
	public byte[] getData()
	{
		return _ylArgData;
	}
	
	public boolean isList()
	{
		return false;
	}
}
